/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers;

import com.uwyn.rife.authentication.Credentials;
import com.uwyn.rife.authentication.CredentialsManager;
import com.uwyn.rife.authentication.credentials.RoleUserCredentials;
import com.uwyn.rife.authentication.credentialsmanagers.ListRoles;
import com.uwyn.rife.authentication.credentialsmanagers.ListUsers;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUsersManager;
import com.uwyn.rife.authentication.credentialsmanagers.Xml2MemoryUsers;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.CantFindXmlPathException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.CantWriteToDestinationException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateLoginException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateRoleException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateUserIdException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.InitializationErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.MissingXmlPathException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.StoreXmlErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UnknownRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UnsupportedCredentialsTypeException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UpdateUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.VerifyCredentialsErrorException;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.SortListComparables;
import com.uwyn.rife.tools.StringEncryptor;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MemoryUsers
implements CredentialsManager,
RoleUsersManager {
    private HashMap<Long, String> mUserIdMapping = new HashMap();
    private TreeMap<String, RoleUserAttributes> mUsers = new TreeMap();
    private TreeMap<String, ArrayList<String>> mRoles = new TreeMap();
    private long mUserIdSequence = 0;
    private long mModificationTime = 0;
    private String mXmlPath = null;
    private ResourceFinder mResourceFinder = null;
    protected StringEncryptor mPasswordEncryptor = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public MemoryUsers() {
    }

    public MemoryUsers(String xmlPath, ResourceFinder resourceFinder) {
        if (xmlPath == null) {
            throw new IllegalArgumentException("xmlPath can't be null.");
        }
        if (0 == xmlPath.length()) {
            throw new IllegalArgumentException("xmlPath can't be empty.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mXmlPath = xmlPath;
        this.mResourceFinder = resourceFinder;
        try {
            this.mModificationTime = resourceFinder.getModificationTime(xmlPath);
        }
        catch (ResourceFinderErrorException e) {
            throw new InitializationErrorException(xmlPath, e);
        }
        this.initialize();
    }

    public String getXmlPath() {
        return this.mXmlPath;
    }

    public StringEncryptor getPasswordEncryptor() {
        return this.mPasswordEncryptor;
    }

    public MemoryUsers setPasswordEncryptor(StringEncryptor passwordEncryptor) {
        this.mPasswordEncryptor = passwordEncryptor;
        return this;
    }

    public static boolean hasRepInstance() {
        return Rep.hasParticipant("ParticipantMemoryUsers");
    }

    public static MemoryUsers getRepInstance() {
        Participant participant = Rep.getParticipant("ParticipantMemoryUsers");
        if (participant == null) {
            return null;
        }
        return (MemoryUsers)participant.getObject();
    }

    public long verifyCredentials(Credentials credentials) {
        RoleUserCredentials role_user = null;
        if (!(credentials instanceof RoleUserCredentials)) {
            throw new UnsupportedCredentialsTypeException(credentials);
        }
        role_user = (RoleUserCredentials)credentials;
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            RoleUserAttributes user_attributes = this.mUsers.get(role_user.getLogin());
            if (user_attributes == null) {
                return -1;
            }
            String password = null;
            try {
                password = StringEncryptor.adaptiveEncrypt(role_user.getPassword(), user_attributes.getPassword());
            }
            catch (NoSuchAlgorithmException e) {
                throw new VerifyCredentialsErrorException(credentials, (Throwable)e);
            }
            if (role_user.getRole() != null) {
                if (user_attributes.isValid(password, role_user.getRole())) {
                    return this.mUsers.get(role_user.getLogin()).getUserId();
                }
            } else if (user_attributes.isValid(password)) {
                return this.mUsers.get(role_user.getLogin()).getUserId();
            }
        }
        return -1;
    }

    public MemoryUsers addRole(String role) {
        if (role == null || 0 == role.length()) {
            throw new AddRoleErrorException(role);
        }
        if (this.mRoles.containsKey(role)) {
            throw new DuplicateRoleException(role);
        }
        this.mRoles.put(role, new ArrayList());
        return this;
    }

    public /* synthetic */ RoleUsersManager addRole(String string) {
        return this.addRole(string);
    }

    public long countRoles() {
        return this.mRoles.size();
    }

    public boolean containsRole(String role) {
        if (role == null || 0 == role.length()) {
            return false;
        }
        return this.mRoles.containsKey(role);
    }

    public MemoryUsers addUser(String login, RoleUserAttributes attributes) {
        if (login == null || 0 == login.length() || attributes == null) {
            throw new AddUserErrorException(login, attributes);
        }
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            if (this.mUsers.containsKey(login)) {
                throw new DuplicateLoginException(login);
            }
            if ((long)-1 == attributes.getUserId()) {
                while (this.mUserIdMapping.containsKey(new Long(this.mUserIdSequence))) {
                    ++this.mUserIdSequence;
                }
                attributes.setUserId(this.mUserIdSequence);
                attributes.setAutomaticUserId(true);
                this.mUserIdMapping.put(new Long(this.mUserIdSequence), login);
            } else {
                if (this.mUserIdMapping.containsKey(new Long(attributes.getUserId()))) {
                    throw new DuplicateUserIdException(attributes.getUserId());
                }
                this.mUserIdMapping.put(new Long(attributes.getUserId()), login);
            }
            RoleUserAttributes attributes_clone = attributes.clone();
            if (this.mPasswordEncryptor != null && !attributes_clone.getPassword().startsWith(this.mPasswordEncryptor.toString())) {
                try {
                    attributes_clone.setPassword(this.mPasswordEncryptor.encrypt(attributes_clone.getPassword()));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AddUserErrorException(login, attributes, e);
                }
            }
            this.mUsers.put(login, attributes_clone);
            this.createRoleLinks(login, attributes_clone);
        }
        return this;
    }

    public /* synthetic */ RoleUsersManager addUser(String string, RoleUserAttributes roleUserAttributes) {
        return this.addUser(string, roleUserAttributes);
    }

    private void createRoleLinks(String login, RoleUserAttributes attributes) {
        if (!$assertionsDisabled && login == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && login.length() <= 0) {
            throw new AssertionError();
        }
        if (attributes.getRoles() != null && attributes.getRoles().size() > 0) {
            ArrayList<String> logins = null;
            Iterator<String> iterator = attributes.getRoles().iterator();
            while (iterator.hasNext()) {
                String role = iterator.next();
                if (!this.mRoles.containsKey(role)) {
                    throw new UnknownRoleErrorException(role, login, attributes);
                }
                logins = this.mRoles.get(role);
                if (logins.contains(login)) continue;
                logins.add(login);
            }
        }
    }

    public RoleUserAttributes getAttributes(String login) {
        if (login == null || 0 == login.length()) {
            return null;
        }
        return this.mUsers.get(login);
    }

    public long countUsers() {
        return this.mUsers.size();
    }

    public boolean listRoles(ListRoles processor) {
        if (processor == null) {
            return false;
        }
        if (0 == this.mRoles.size()) {
            return true;
        }
        boolean result = false;
        Iterator iterator = ((Collection)this.mRoles.keySet()).iterator();
        while (iterator.hasNext()) {
            String role = (String)iterator.next();
            result = true;
            if (!processor.foundRole(role)) break;
        }
        return result;
    }

    public boolean listUsers(ListUsers processor) {
        if (processor == null) {
            return false;
        }
        if (0 == this.mUsers.size()) {
            return false;
        }
        boolean result = false;
        RoleUserAttributes attributes = null;
        Iterator iterator = ((Collection)this.mUsers.keySet()).iterator();
        while (iterator.hasNext()) {
            String login = (String)iterator.next();
            result = true;
            attributes = this.mUsers.get(login);
            if (!processor.foundUser(attributes.getUserId(), login, attributes.getPassword())) break;
        }
        return result;
    }

    public boolean listUsers(ListUsers processor, int limit, int offset) {
        if (processor == null || limit <= 0 || 0 == this.mUsers.size()) {
            return false;
        }
        boolean result = false;
        RoleUserAttributes attributes = null;
        int count = 0;
        Iterator iterator = ((Collection)this.mUsers.keySet()).iterator();
        while (iterator.hasNext()) {
            String login = (String)iterator.next();
            if (count < offset) {
                ++count;
                continue;
            }
            if (count - offset >= limit) break;
            ++count;
            result = true;
            attributes = this.mUsers.get(login);
            if (!processor.foundUser(attributes.getUserId(), login, attributes.getPassword())) break;
        }
        return result;
    }

    public boolean containsUser(String login) {
        if (login == null || 0 == login.length()) {
            return false;
        }
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            return this.mUsers.containsKey(login);
        }
    }

    public boolean listUsersInRole(ListUsers processor, String role) {
        if (processor == null) {
            return false;
        }
        if (role == null || 0 == role.length()) {
            return false;
        }
        if (0 == this.mUsers.size()) {
            return false;
        }
        boolean result = false;
        RoleUserAttributes attributes = null;
        Iterator iterator = ((Collection)this.mUsers.keySet()).iterator();
        while (iterator.hasNext()) {
            String login = (String)iterator.next();
            attributes = this.mUsers.get(login);
            if (attributes.getRoles() == null || !attributes.getRoles().contains(role)) continue;
            result = true;
            if (!processor.foundUser(attributes.getUserId(), login, attributes.getPassword())) break;
        }
        return result;
    }

    public boolean isUserInRole(long userId, String role) {
        if (userId < (long)0 || role == null || 0 == role.length()) {
            return false;
        }
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            String login = this.mUserIdMapping.get(new Long(userId));
            if (login == null) {
                return false;
            }
            RoleUserAttributes user_attributes = this.mUsers.get(login);
            if (user_attributes == null) {
                return false;
            }
            return user_attributes.isInRole(role);
        }
    }

    public String getLogin(long userId) {
        if (userId < (long)0) {
            return null;
        }
        String login = null;
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            login = this.mUserIdMapping.get(new Long(userId));
        }
        return login;
    }

    public long getUserId(String login) {
        if (login == null || 0 == login.length()) {
            return -1;
        }
        long userid = -1;
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            RoleUserAttributes attributes = this.mUsers.get(login);
            if (attributes != null) {
                userid = attributes.getUserId();
            }
        }
        return userid;
    }

    public boolean updateUser(String login, RoleUserAttributes attributes) {
        if (login == null || 0 == login.length() || attributes == null) {
            throw new UpdateUserErrorException(login, attributes);
        }
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            if (!this.mUsers.containsKey(login)) {
                return false;
            }
            RoleUserAttributes current_attributes = this.mUsers.get(login);
            RoleUserAttributes attributes_clone = attributes.clone();
            if (attributes_clone.getPassword() == null) {
                attributes_clone.setPassword(current_attributes.getPassword());
            } else if (this.mPasswordEncryptor != null && !attributes_clone.getPassword().startsWith(this.mPasswordEncryptor.toString())) {
                try {
                    attributes_clone.setPassword(this.mPasswordEncryptor.encrypt(attributes_clone.getPassword()));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new UpdateUserErrorException(login, attributes, e);
                }
            }
            attributes_clone.setUserId(current_attributes.getUserId());
            this.removeRoleLinks(login);
            this.mUsers.put(login, attributes_clone);
            this.createRoleLinks(login, attributes_clone);
        }
        return true;
    }

    public boolean removeUser(String login) {
        if (login == null || 0 == login.length()) {
            return false;
        }
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            this.removeRoleLinks(login);
            return this.mUsers.remove(login) != null;
            {
            }
        }
    }

    public boolean removeUser(long userId) {
        if (userId < (long)0) {
            return false;
        }
        String login = null;
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            if (this.mUserIdMapping.get(new Long(userId)) == null) {
                return false;
            }
            login = this.mUserIdMapping.get(new Long(userId));
            this.removeRoleLinks(login);
            return this.mUsers.remove(login) != null;
            {
            }
        }
    }

    public boolean removeRole(String name) {
        if (name == null || 0 == name.length()) {
            return false;
        }
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            if (this.mRoles.remove(name) == null) {
                return false;
            }
            Iterator iterator = ((Collection)this.mUsers.keySet()).iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Collection<String> roles = this.mUsers.get(key).getRoles();
                if (roles == null || !roles.contains(name)) continue;
                roles.remove(name);
            }
        }
        return true;
    }

    private void removeRoleLinks(String login) {
        if (!$assertionsDisabled && login == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && login.length() <= 0) {
            throw new AssertionError();
        }
        RoleUserAttributes attributes = this.mUsers.get(login);
        if (attributes != null && attributes.getRoles() != null && attributes.getRoles().size() > 0) {
            ArrayList<String> logins = null;
            ArrayList<String> roles_to_delete = null;
            Iterator<String> iterator = attributes.getRoles().iterator();
            while (iterator.hasNext()) {
                String role = iterator.next();
                logins = this.mRoles.get(role);
                logins.remove(login);
                if (0 != logins.size()) continue;
                if (roles_to_delete == null) {
                    roles_to_delete = new ArrayList<String>();
                }
                roles_to_delete.add(role);
            }
            if (roles_to_delete != null) {
                Iterator iterator2 = ((Collection)roles_to_delete).iterator();
                while (iterator2.hasNext()) {
                    String role = (String)iterator2.next();
                    this.mRoles.remove(role);
                }
            }
        }
    }

    public void clearUsers() {
        MemoryUsers memoryUsers = this;
        synchronized (memoryUsers) {
            this.mUsers = new TreeMap();
            this.mRoles = new TreeMap();
        }
    }

    public boolean listUserRoles(String login, ListRoles processor) {
        if (this.mUsers.get(login) == null) {
            return false;
        }
        if (processor == null) {
            return false;
        }
        if (0 == this.mRoles.size()) {
            return true;
        }
        boolean result = false;
        Iterator iterator = ((Collection)this.mRoles.keySet()).iterator();
        while (iterator.hasNext()) {
            String role = (String)iterator.next();
            RoleUserAttributes attributes = null;
            MemoryUsers memoryUsers = this;
            synchronized (memoryUsers) {
                attributes = this.mUsers.get(login);
            }
            if (!attributes.isInRole(role)) continue;
            result = true;
            if (!processor.foundRole(role)) break;
        }
        return result;
    }

    private void initialize() {
        try {
            Xml2MemoryUsers xml_memoryusers = new Xml2MemoryUsers();
            xml_memoryusers.processXml(this.mXmlPath, this.mResourceFinder);
            MemoryUsers memoryUsers = this;
            synchronized (memoryUsers) {
                Iterator iterator = ((Collection)xml_memoryusers.getUsers().entrySet()).iterator();
                while (iterator.hasNext()) {
                    Map.Entry user_entry = (Map.Entry)iterator.next();
                    RoleUserAttributes attributes = (RoleUserAttributes)user_entry.getValue();
                    Iterator<String> iterator2 = attributes.getRoles().iterator();
                    while (iterator2.hasNext()) {
                        String role = iterator2.next();
                        if (this.containsRole(role)) continue;
                        this.addRole(role);
                    }
                    this.addUser((String)user_entry.getKey(), attributes);
                }
            }
        }
        catch (XmlErrorException e) {
            throw new InitializationErrorException(this.mXmlPath, e);
        }
    }

    public String toXml() {
        StringBuffer xml_output;
        StringBuffer stringBuffer = xml_output = new StringBuffer();
        synchronized (stringBuffer) {
            xml_output.append("<credentials>\n");
            SortListComparables arraylist_sort = new SortListComparables();
            ArrayList<String> logins_list = new ArrayList<String>(this.mUsers.keySet());
            RoleUserAttributes user_attributes = null;
            arraylist_sort.sort(logins_list);
            Iterator iterator = ((Collection)logins_list).iterator();
            while (iterator.hasNext()) {
                String login = (String)iterator.next();
                user_attributes = this.mUsers.get(login);
                xml_output.append("\t<user login=\"" + StringUtils.encodeXml(login) + "\"");
                if (!user_attributes.isAutomaticUserId()) {
                    xml_output.append(" userid=\"" + user_attributes.getUserId() + "\"");
                }
                xml_output.append(">\n");
                xml_output.append("\t\t<password>" + StringUtils.encodeXml(user_attributes.getPassword()) + "</password>\n");
                if (user_attributes.getRoles() != null && user_attributes.getRoles().size() > 0) {
                    ArrayList<String> roles = new ArrayList<String>(user_attributes.getRoles());
                    arraylist_sort.sort(roles);
                    Iterator iterator2 = ((Collection)roles).iterator();
                    while (iterator2.hasNext()) {
                        String role = (String)iterator2.next();
                        xml_output.append("\t\t<role>" + StringUtils.encodeXml(role) + "</role>\n");
                    }
                }
                xml_output.append("\t</user>\n");
            }
            xml_output.append("</credentials>\n");
            return xml_output.toString();
        }
    }

    public void storeToXml() {
        String xmlpath = null;
        URL xmlpath_resource = null;
        xmlpath = this.getXmlPath();
        if (xmlpath == null) {
            throw new MissingXmlPathException();
        }
        xmlpath_resource = this.mResourceFinder.getResource(xmlpath);
        if (xmlpath_resource == null) {
            throw new CantFindXmlPathException(xmlpath);
        }
        this.storeToXml(new File(URLDecoder.decode(xmlpath_resource.getPath())));
    }

    public synchronized void storeToXml(File destination) {
        if (destination == null || destination.exists() && !destination.canWrite()) {
            throw new CantWriteToDestinationException(destination);
        }
        StringBuffer content = new StringBuffer("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + "<!DOCTYPE credentials SYSTEM \"/dtd/users.dtd\">\n");
        content.append(this.toXml());
        try {
            FileUtils.writeString(content.toString(), destination);
        }
        catch (FileUtilsErrorException e) {
            throw new StoreXmlErrorException(destination, (Throwable)e);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.MemoryUsers");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

