/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.asm.attrs;

import com.uwyn.rife.asm.Attribute;
import com.uwyn.rife.asm.ByteVector;
import com.uwyn.rife.asm.ClassReader;
import com.uwyn.rife.asm.ClassWriter;
import com.uwyn.rife.asm.Label;
import com.uwyn.rife.asm.attrs.StackMapFrame;
import java.util.ArrayList;
import java.util.HashSet;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public ArrayList frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapFrame getFrame(Label label) {
        int i = 0;
        while (i < this.frames.size()) {
            StackMapFrame frame = (StackMapFrame)this.frames.get(i);
            if (frame.label == label) {
                return frame;
            }
            ++i;
        }
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isCodeAttribute() {
        return true;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapAttribute attr = new StackMapAttribute();
        int codeSize = cr.readInt(codeOff + 4);
        int size = 0;
        if (codeSize > 65535) {
            size = cr.readInt(off);
            off += 4;
        } else {
            size = cr.readShort(off);
            off += 2;
        }
        int i = 0;
        while (i < size) {
            StackMapFrame frame = new StackMapFrame();
            off = frame.read(cr, off, buf, codeOff, labels);
            attr.frames.add(frame);
            ++i;
        }
        return attr;
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector bv = new ByteVector();
        if (code != null && code.length > 65535) {
            bv.putInt(this.frames.size());
        } else {
            bv.putShort(this.frames.size());
        }
        int i = 0;
        while (i < this.frames.size()) {
            ((StackMapFrame)this.frames.get(i)).write(cw, maxStack, maxLocals, bv);
            ++i;
        }
        return bv;
    }

    protected Label[] getLabels() {
        HashSet labels = new HashSet();
        int i = 0;
        while (i < this.frames.size()) {
            ((StackMapFrame)this.frames.get(i)).getLabels(labels);
            ++i;
        }
        return (Label[])((Object[])labels.toArray(new Label[labels.size()]));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StackMap[");
        int i = 0;
        while (i < this.frames.size()) {
            sb.append('\n').append('[').append(this.frames.get(i)).append(']');
            ++i;
        }
        sb.append("\n]");
        return sb.toString();
    }
}

