/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.asm;

import com.uwyn.rife.asm.AnnotationVisitor;
import com.uwyn.rife.asm.Attribute;
import com.uwyn.rife.asm.ClassVisitor;
import com.uwyn.rife.asm.ClassWriter;
import com.uwyn.rife.asm.FieldVisitor;
import com.uwyn.rife.asm.Label;
import com.uwyn.rife.asm.MethodVisitor;
import com.uwyn.rife.asm.Type;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    private int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        this.strings = new String[this.items.length];
        int max = 0;
        int index = off + 10;
        int i = 1;
        while (i < this.items.length) {
            int size;
            this.items[i] = index + 1;
            byte tag = b[index];
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    max = size > max ? size : max;
                    break;
                }
                default: {
                    size = 3;
                    break;
                }
            }
            index += size;
            ++i;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is));
    }

    public ClassReader(String name) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean skipDebug) {
        this.accept(classVisitor, new Attribute[0], skipDebug);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attrs, boolean skipDebug) {
        int k;
        String desc;
        Attribute attr;
        String attrName;
        int j;
        byte[] b = this.b;
        char[] c = new char[this.maxStringLength];
        int anns = 0;
        int ianns = 0;
        Attribute cattrs = null;
        int u = this.header;
        int access = this.readUnsignedShort(u);
        String name = this.readClass(u + 2, c);
        int v = this.items[this.readUnsignedShort(u + 4)];
        String superClassName = v == 0 ? null : this.readUTF8(v, c);
        String[] implementedItfs = new String[this.readUnsignedShort(u + 6)];
        int w = 0;
        u += 8;
        int i = 0;
        while (i < implementedItfs.length) {
            implementedItfs[i] = this.readClass(u, c);
            u += 2;
            ++i;
        }
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                j += -1;
            }
            i += -1;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                j += -1;
            }
            i += -1;
        }
        String signature = null;
        String sourceFile = null;
        String sourceDebug = null;
        String enclosingOwner = null;
        String enclosingName = null;
        String enclosingDesc = null;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            attrName = this.readUTF8(v, c);
            if (attrName.equals("SourceFile")) {
                sourceFile = this.readUTF8(v + 6, c);
            } else if (attrName.equals("Deprecated")) {
                access |= 0x20000;
            } else if (attrName.equals("Synthetic")) {
                access |= 0x1000;
            } else if (attrName.equals("InnerClasses")) {
                w = v + 6;
            } else if (attrName.equals("Signature")) {
                signature = this.readUTF8(v + 6, c);
            } else if (attrName.equals("SourceDebugExtension")) {
                int len = this.readInt(v + 2);
                sourceDebug = this.readUTF(v + 6, len, new char[len]);
            } else if (attrName.equals("EnclosingMethod")) {
                enclosingOwner = this.readClass(v + 6, c);
                int item = this.readUnsignedShort(v + 8);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c);
                    enclosingDesc = this.readUTF8(this.items[item], c);
                }
            } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                anns = v + 6;
            } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                ianns = v + 6;
            } else {
                attr = this.readAttribute(attrs, attrName, v + 6, this.readInt(v + 2), c, -1, null);
                if (attr != null) {
                    attr.next = cattrs;
                    cattrs = attr;
                }
            }
            v += 6 + this.readInt(v + 2);
            i += -1;
        }
        classVisitor.visit(this.readInt(4), access, name, signature, superClassName, implementedItfs);
        if (sourceFile != null || sourceDebug != null) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (enclosingOwner != null) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        i = 1;
        while (i >= 0) {
            int n = v = i == 0 ? ianns : anns;
            if (v != 0) {
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    desc = this.readUTF8(v, c);
                    v += 2;
                    v = this.readAnnotationValues(v, c, classVisitor.visitAnnotation(desc, i != 0));
                    j += -1;
                }
            }
            i += -1;
        }
        while (cattrs != null) {
            attr = cattrs.next;
            cattrs.next = null;
            classVisitor.visitAttribute(cattrs);
            cattrs = attr;
        }
        if (w != 0) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                i += -1;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            int fieldValueItem = 0;
            signature = null;
            anns = 0;
            ianns = 0;
            cattrs = null;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                if (attrName.equals("ConstantValue")) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                } else if (attrName.equals("Synthetic")) {
                    access |= 0x1000;
                } else if (attrName.equals("Deprecated")) {
                    access |= 0x20000;
                } else if (attrName.equals("Signature")) {
                    signature = this.readUTF8(u + 6, c);
                } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                    anns = u + 6;
                } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                    ianns = u + 6;
                } else {
                    attr = this.readAttribute(attrs, attrName, u + 6, this.readInt(u + 2), c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += 6 + this.readInt(u + 2);
                j += -1;
            }
            Object value = fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c);
            FieldVisitor fv = classVisitor.visitField(access, name, desc, signature, value);
            if (fv != null) {
                j = 1;
                while (j >= 0) {
                    int n = v = j == 0 ? ianns : anns;
                    if (v != 0) {
                        k = this.readUnsignedShort(v);
                        v += 2;
                        while (k > 0) {
                            desc = this.readUTF8(v, c);
                            v += 2;
                            v = this.readAnnotationValues(v, c, fv.visitAnnotation(desc, j != 0));
                            k += -1;
                        }
                    }
                    j += -1;
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    fv.visitAttribute(cattrs);
                    cattrs = attr;
                }
                fv.visitEnd();
            }
            i += -1;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            String[] exceptions;
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            signature = null;
            anns = 0;
            ianns = 0;
            int dann = 0;
            int mpanns = 0;
            int impanns = 0;
            cattrs = null;
            v = 0;
            w = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                int attrSize = this.readInt(u += 2);
                u += 4;
                if (attrName.equals("Code")) {
                    v = u;
                } else if (attrName.equals("Exceptions")) {
                    w = u;
                } else if (attrName.equals("Synthetic")) {
                    access |= 0x1000;
                } else if (attrName.equals("Deprecated")) {
                    access |= 0x20000;
                } else if (attrName.equals("Signature")) {
                    signature = this.readUTF8(u, c);
                } else if (attrName.equals("AnnotationDefault")) {
                    dann = u;
                } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                    anns = u;
                } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                    ianns = u;
                } else if (attrName.equals("RuntimeVisibleParameterAnnotations")) {
                    mpanns = u;
                } else if (attrName.equals("RuntimeInvisibleParameterAnnotations")) {
                    impanns = u;
                } else {
                    attr = this.readAttribute(attrs, attrName, u, attrSize, c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += attrSize;
                j += -1;
            }
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                j = 0;
                while (j < exceptions.length) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                    ++j;
                }
            }
            MethodVisitor mv = classVisitor.visitMethod(access, name, desc, signature, exceptions);
            if (mv != null) {
                if (dann != 0) {
                    AnnotationVisitor dv = mv.visitAnnotationDefault();
                    this.readAnnotationValue(dann, c, null, dv);
                    dv.visitEnd();
                }
                j = 1;
                while (j >= 0) {
                    int n = w = j == 0 ? ianns : anns;
                    if (w != 0) {
                        k = this.readUnsignedShort(w);
                        w += 2;
                        while (k > 0) {
                            desc = this.readUTF8(w, c);
                            w += 2;
                            w = this.readAnnotationValues(w, c, mv.visitAnnotation(desc, j != 0));
                            k += -1;
                        }
                    }
                    j += -1;
                }
                if (mpanns != 0) {
                    this.readParameterAnnotations(mpanns, c, true, mv);
                }
                if (impanns != 0) {
                    this.readParameterAnnotations(impanns, c, false, mv);
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    mv.visitAttribute(cattrs);
                    cattrs = attr;
                }
            }
            if (mv != null && v != 0) {
                Label l;
                int label;
                int maxStack = this.readUnsignedShort(v);
                int maxLocals = this.readUnsignedShort(v + 2);
                int codeLength = this.readInt(v + 4);
                int codeStart = v += 8;
                int codeEnd = v + codeLength;
                Label[] labels = new Label[codeLength + 1];
                block49: while (v < codeEnd) {
                    int opcode = b[v] & 0xFF;
                    switch (ClassWriter.TYPE[opcode]) {
                        case 0: 
                        case 4: {
                            ++v;
                            break;
                        }
                        case 8: {
                            label = v - codeStart + this.readShort(v + 1);
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            v += 3;
                            break;
                        }
                        case 9: {
                            label = v - codeStart + this.readInt(v + 1);
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            v += 5;
                            break;
                        }
                        case 16: {
                            opcode = b[v + 1] & 0xFF;
                            if (opcode == 132) {
                                v += 6;
                                break;
                            }
                            v += 4;
                            break;
                        }
                        case 13: {
                            w = v - codeStart;
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            v += 4;
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            j = this.readInt(v);
                            j = this.readInt(v += 4) - j + 1;
                            v += 4;
                            while (j > 0) {
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                j += -1;
                            }
                            continue block49;
                        }
                        case 14: {
                            w = v - codeStart;
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            v += 4;
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            j = this.readInt(v);
                            v += 4;
                            while (j > 0) {
                                label = w + this.readInt(v += 4);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                j += -1;
                            }
                            continue block49;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            v += 2;
                            break;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            v += 3;
                            break;
                        }
                        case 7: {
                            v += 5;
                            break;
                        }
                        default: {
                            v += 4;
                            break;
                        }
                    }
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    label = this.readUnsignedShort(v);
                    if (labels[label] == null) {
                        labels[label] = new Label();
                    }
                    if (labels[label = this.readUnsignedShort(v + 2)] == null) {
                        labels[label] = new Label();
                    }
                    if (labels[label = this.readUnsignedShort(v + 4)] == null) {
                        labels[label] = new Label();
                    }
                    v += 8;
                    j += -1;
                }
                int varTable = 0;
                int varTypeTable = 0;
                cattrs = null;
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    attrName = this.readUTF8(v, c);
                    if (attrName.equals("LocalVariableTable")) {
                        if (!skipDebug) {
                            varTable = v + 6;
                            k = this.readUnsignedShort(v + 6);
                            w = v + 8;
                            while (k > 0) {
                                label = this.readUnsignedShort(w);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                    labels[label] = new Label();
                                }
                                w += 10;
                                k += -1;
                            }
                        }
                    } else if (attrName.equals("LocalVariableTypeTable")) {
                        varTypeTable = v + 6;
                    } else if (attrName.equals("LineNumberTable")) {
                        if (!skipDebug) {
                            k = this.readUnsignedShort(v + 6);
                            w = v + 8;
                            while (k > 0) {
                                label = this.readUnsignedShort(w);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                labels[label].line = this.readUnsignedShort(w + 2);
                                w += 4;
                                k += -1;
                            }
                        }
                    } else {
                        k = 0;
                        while (k < attrs.length) {
                            if (attrs[k].type.equals(attrName) && (attr = attrs[k].read(this, v + 6, this.readInt(v + 2), c, codeStart - 8, labels)) != null) {
                                attr.next = cattrs;
                                cattrs = attr;
                            }
                            ++k;
                        }
                    }
                    v += 6 + this.readInt(v + 2);
                    j += -1;
                }
                v = codeStart;
                while (v < codeEnd) {
                    w = v - codeStart;
                    l = labels[w];
                    if (l != null) {
                        mv.visitLabel(l);
                        if (!skipDebug && l.line > 0) {
                            mv.visitLineNumber(l.line, l);
                        }
                    }
                    int opcode = b[v] & 0xFF;
                    switch (ClassWriter.TYPE[opcode]) {
                        case 0: {
                            mv.visitInsn(opcode);
                            ++v;
                            break;
                        }
                        case 4: {
                            if (opcode > 54) {
                                mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                            } else {
                                mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                            }
                            ++v;
                            break;
                        }
                        case 8: {
                            mv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                            v += 3;
                            break;
                        }
                        case 9: {
                            mv.visitJumpInsn(opcode, labels[w + this.readInt(v + 1)]);
                            v += 5;
                            break;
                        }
                        case 16: {
                            opcode = b[v + 1] & 0xFF;
                            if (opcode == 132) {
                                mv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                                v += 6;
                                break;
                            }
                            mv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                            v += 4;
                            break;
                        }
                        case 13: {
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            int min = this.readInt(v += 4);
                            int max = this.readInt(v += 4);
                            v += 4;
                            Label[] table = new Label[max - min + 1];
                            j = 0;
                            while (j < table.length) {
                                table[j] = labels[w + this.readInt(v)];
                                v += 4;
                                ++j;
                            }
                            mv.visitTableSwitchInsn(min, max, labels[label], table);
                            break;
                        }
                        case 14: {
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            j = this.readInt(v += 4);
                            v += 4;
                            int[] keys = new int[j];
                            Label[] values = new Label[j];
                            j = 0;
                            while (j < keys.length) {
                                keys[j] = this.readInt(v);
                                values[j] = labels[w + this.readInt(v += 4)];
                                v += 4;
                                ++j;
                            }
                            mv.visitLookupSwitchInsn(labels[label], keys, values);
                            break;
                        }
                        case 3: {
                            mv.visitVarInsn(opcode, b[v + 1] & 0xFF);
                            v += 2;
                            break;
                        }
                        case 1: {
                            mv.visitIntInsn(opcode, b[v + 1]);
                            v += 2;
                            break;
                        }
                        case 2: {
                            mv.visitIntInsn(opcode, this.readShort(v + 1));
                            v += 3;
                            break;
                        }
                        case 10: {
                            mv.visitLdcInsn(this.readConst(b[v + 1] & 0xFF, c));
                            v += 2;
                            break;
                        }
                        case 11: {
                            mv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                            v += 3;
                            break;
                        }
                        case 6: 
                        case 7: {
                            int cpIndex = this.items[this.readUnsignedShort(v + 1)];
                            String iowner = this.readClass(cpIndex, c);
                            cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                            String iname = this.readUTF8(cpIndex, c);
                            String idesc = this.readUTF8(cpIndex + 2, c);
                            if (opcode < 182) {
                                mv.visitFieldInsn(opcode, iowner, iname, idesc);
                            } else {
                                mv.visitMethodInsn(opcode, iowner, iname, idesc);
                            }
                            if (opcode == 185) {
                                v += 5;
                                break;
                            }
                            v += 3;
                            break;
                        }
                        case 5: {
                            mv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                            v += 3;
                            break;
                        }
                        case 12: {
                            mv.visitIincInsn(b[v + 1] & 0xFF, b[v + 2]);
                            v += 3;
                            break;
                        }
                        default: {
                            mv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 0xFF);
                            v += 4;
                            break;
                        }
                    }
                }
                l = labels[codeEnd - codeStart];
                if (l != null) {
                    mv.visitLabel(l);
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    Label start = labels[this.readUnsignedShort(v)];
                    Label end = labels[this.readUnsignedShort(v + 2)];
                    Label handler = labels[this.readUnsignedShort(v + 4)];
                    int type = this.readUnsignedShort(v + 6);
                    if (type == 0) {
                        mv.visitTryCatchBlock(start, end, handler, null);
                    } else {
                        mv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                    }
                    v += 8;
                    j += -1;
                }
                if (!skipDebug && varTable != 0) {
                    int[] typeTable = null;
                    if (varTypeTable != 0) {
                        w = varTypeTable;
                        k = this.readUnsignedShort(w) * 3;
                        w += 2;
                        typeTable = new int[k];
                        while (k > 0) {
                            typeTable[k += -1] = w + 6;
                            typeTable[k += -1] = this.readUnsignedShort(w + 8);
                            typeTable[k += -1] = this.readUnsignedShort(w);
                            w += 10;
                        }
                    }
                    w = varTable;
                    k = this.readUnsignedShort(w);
                    w += 2;
                    while (k > 0) {
                        int start = this.readUnsignedShort(w);
                        int length = this.readUnsignedShort(w + 2);
                        int index = this.readUnsignedShort(w + 8);
                        String vsignature = null;
                        if (typeTable != null) {
                            int a = 0;
                            while (a < typeTable.length) {
                                if (typeTable[a] == start && typeTable[a + 1] == index) {
                                    vsignature = this.readUTF8(typeTable[a + 2], c);
                                    break;
                                }
                                a += 3;
                            }
                        }
                        mv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), vsignature, labels[start], labels[start + length], index);
                        w += 10;
                        k += -1;
                    }
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    mv.visitAttribute(cattrs);
                    cattrs = attr;
                }
                mv.visitMaxs(maxStack, maxLocals);
            }
            if (mv != null) {
                mv.visitEnd();
            }
            i += -1;
        }
        classVisitor.visitEnd();
    }

    private void readParameterAnnotations(int v, char[] buf, boolean visible, MethodVisitor mv) {
        int n = this.b[v++] & 0xFF;
        int i = 0;
        while (i < n) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                String desc = this.readUTF8(v, buf);
                v += 2;
                AnnotationVisitor av = mv.visitParameterAnnotation(i, desc, visible);
                v = this.readAnnotationValues(v, buf, av);
                j += -1;
            }
            ++i;
        }
    }

    private int readAnnotationValues(int v, char[] buf, AnnotationVisitor av) {
        int i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            String name = this.readUTF8(v, buf);
            v += 2;
            v = this.readAnnotationValue(v, buf, name, av);
            i += -1;
        }
        av.visitEnd();
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name, AnnotationVisitor av) {
        block0 : switch (this.readByte(v++)) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 90: {
                av.visit(name, this.readInt(this.items[this.readUnsignedShort(v)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name, new Short((short)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name, new Character((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                String desc = this.readUTF8(v, buf);
                v += 2;
                v = this.readAnnotationValues(v, buf, av.visitAnnotation(name, desc));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v);
                v += 2;
                switch (this.readByte(v++)) {
                    case 66: {
                        byte[] bv = new byte[size];
                        int i = 0;
                        while (i < size) {
                            bv[i] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                            ++i;
                        }
                        av.visit(name, bv);
                        v += -1;
                        break block0;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        int i = 0;
                        while (i < size) {
                            zv[i] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                            ++i;
                        }
                        av.visit(name, zv);
                        v += -1;
                        break block0;
                    }
                    case 83: {
                        short[] sv = new short[size];
                        int i = 0;
                        while (i < size) {
                            sv[i] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                            ++i;
                        }
                        av.visit(name, sv);
                        v += -1;
                        break block0;
                    }
                    case 67: {
                        char[] cv = new char[size];
                        int i = 0;
                        while (i < size) {
                            cv[i] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                            ++i;
                        }
                        av.visit(name, cv);
                        v += -1;
                        break block0;
                    }
                    case 73: {
                        int[] iv = new int[size];
                        int i = 0;
                        while (i < size) {
                            iv[i] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                            ++i;
                        }
                        av.visit(name, iv);
                        v += -1;
                        break block0;
                    }
                    case 74: {
                        long[] lv = new long[size];
                        int i = 0;
                        while (i < size) {
                            lv[i] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                            ++i;
                        }
                        av.visit(name, lv);
                        v += -1;
                        break block0;
                    }
                    case 70: {
                        float[] fv = new float[size];
                        int i = 0;
                        while (i < size) {
                            fv[i] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                            ++i;
                        }
                        av.visit(name, fv);
                        v += -1;
                        break block0;
                    }
                    case 68: {
                        double[] dv = new double[size];
                        int i = 0;
                        while (i < size) {
                            dv[i] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                            ++i;
                        }
                        av.visit(name, dv);
                        v += -1;
                        break block0;
                    }
                }
                --v;
                AnnotationVisitor aav = av.visitArray(name);
                int i = size;
                while (i > 0) {
                    v = this.readAnnotationValue(v, buf, null, aav);
                    i += -1;
                }
                aav.visitEnd();
            }
        }
        return v;
    }

    private Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].type.equals(type)) {
                return attrs[i].read(this, off, len, buf, codeOff, labels);
            }
            ++i;
        }
        return new Attribute(type);
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int readByte(int index) {
        return this.b[index] & 0xFF;
    }

    public int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        byte[] b = this.b;
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index = this.items[item];
        this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
        return this.strings[item];
    }

    private String readUTF(int index, int utfLen, char[] buf) {
        int endIndex = index + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        while (index < endIndex) {
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    byte d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    break;
                }
                default: {
                    byte d = b[index++];
                    byte e = b[index++];
                    buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
                    break;
                }
            }
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index = this.items[item];
        switch (this.b[index - 1]) {
            case 3: {
                return new Integer(this.readInt(index));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index)));
            }
            case 5: {
                return new Long(this.readLong(index));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index)));
            }
            case 7: {
                String s = this.readUTF8(index, buf);
                return Type.getType(s.charAt(0) == '[' ? s : "L" + s + ";");
            }
        }
        return this.readUTF8(index, buf);
    }
}

