/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.publish.githubpages.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gradle.api.credentials.PasswordCredentials;

public final class GitHubRepositoryUtils {
    private GitHubRepositoryUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createOrFetchOrClone(File repositoryDirectory, URI repositoryUri) throws IOException, GitAPIException {
        if (GitHubRepositoryUtils.isGitRepository(repositoryDirectory)) {
            try (Git git = Git.open((File)repositoryDirectory);){
                GitHubRepositoryUtils.cleanRepository(git);
                if (!GitHubRepositoryUtils.hasGitHubPagesBranch(repositoryUri)) return;
                git.fetch().call();
                git.checkout().setName("gh-pages").setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/gh-pages").call();
                git.reset().setMode(ResetCommand.ResetType.HARD).setRef("origin/gh-pages").call();
                return;
            }
        }
        try (Git git = Git.cloneRepository().setDirectory(repositoryDirectory).setURI(repositoryUri.toString()).setNoCheckout(true).setNoTags().call();){
            if (GitHubRepositoryUtils.hasGitHubPagesBranch(repositoryUri)) {
                git.checkout().setCreateBranch(true).setName("gh-pages").setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/gh-pages").call();
                return;
            } else {
                git.checkout().setOrphan(true).setName("gh-pages").call();
                git.remoteAdd().setName("origin").setUri(new URIish(repositoryDirectory.toString())).call();
            }
            return;
        }
        catch (URISyntaxException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static void cleanRepository(Git git) throws GitAPIException {
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
        git.clean().setCleanDirectories(true).setForce(true).call();
    }

    public static void commitAndPushAllFiles(File repositoryDirectory, @Nullable PasswordCredentials credentials) throws IOException, GitAPIException {
        try (Git git = Git.open((File)repositoryDirectory);){
            git.add().addFilepattern(".").call();
            git.commit().setAuthor("nokeedevbot", "bot@nokee.dev").setMessage("Publish by nokeedevbot").setAll(true).call();
            PushCommand pushCommand = git.push();
            if (credentials != null) {
                pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(credentials.getUsername(), credentials.getPassword()));
            }
            pushCommand.call();
        }
    }

    private static boolean hasGitHubPagesBranch(URI repositoryUri) throws GitAPIException {
        Collection refs = Git.lsRemoteRepository().setHeads(true).setTags(false).setRemote(repositoryUri.toString()).call();
        return refs.stream().anyMatch(it -> it.getName().equals("refs/heads/gh-pages"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isGitRepository(File repositoryDirectory) {
        try (FileRepository repository = new FileRepository(new File(repositoryDirectory, ".git"));){
            boolean bl = repository.getObjectDatabase().exists();
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static URI inferGitHubHttpRepositoryUri(File repositoryDirectory) throws IOException, GitAPIException {
        Throwable throwable = null;
        try (Git git = Git.open((File)repositoryDirectory);){
            List remotes = git.remoteList().call();
            if (remotes.isEmpty()) {
                throw new RuntimeException(String.format("Unable to infer GitHub HTTP repository URI at '%s' because no remotes are available.", repositoryDirectory.getAbsolutePath()));
            }
            List uris = ((RemoteConfig)remotes.iterator().next()).getURIs();
            if (uris.isEmpty()) {
                throw new RuntimeException(String.format("Unable to infer GitHub HTTP repository URI at '%s' because no remotes are available.", repositoryDirectory.getAbsolutePath()));
            }
            URIish uri = (URIish)uris.iterator().next();
            try {
                URI uRI = new URI(uri.toASCIIString());
                return uRI;
            }
            catch (URISyntaxException e) {
                try {
                    throw new RuntimeException(String.format("Unable to infer GitHub HTTP repository URI at '%s' because we couldn't parse the remote URI: '%s'.", repositoryDirectory.getAbsolutePath(), uri.toString()), e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }
}

