/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.publish.githubpages.internal;

import dev.gradleplugins.documentationkit.publish.githubpages.internal.GitHubRepositoryUtils;
import dev.gradleplugins.documentationkit.publish.githubpages.tasks.PublishToGitHubPages;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskProvider;

public class GitHubPagesPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_GITHUB_PAGES_LIFECYCLE_TASK_NAME = "publishToGitHubPages";

    public void apply(Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        TaskProvider publishTask = project.getTasks().register(PUBLISH_GITHUB_PAGES_LIFECYCLE_TASK_NAME, GitHubPagesPublishPlugin.defaultClass(PublishToGitHubPages.class), task -> {
            task.setGroup("publishing");
            task.setDescription("Publishes site produced by this project to GitHub pages.");
            task.getCredentials().convention(project.getProviders().credentials(PasswordCredentials.class, PUBLISH_GITHUB_PAGES_LIFECYCLE_TASK_NAME));
            task.getUri().convention(project.provider(() -> GitHubRepositoryUtils.inferGitHubHttpRepositoryUri(project.getRootDir())));
        });
        project.getTasks().named("publish", task -> task.dependsOn(new Object[]{publishTask}));
    }

    private static <T> Class<T> defaultClass(Class<T> tClass) {
        return Class.forName(tClass.getName());
    }
}

