/*
 * Decompiled with CFR 0.152.
 */
package dev.gradleplugins.documentationkit.publish.githubpages.tasks;

import com.google.common.hash.Hashing;
import dev.gradleplugins.documentationkit.publish.githubpages.internal.GitHubRepositoryUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import javax.inject.Inject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.DefaultTask;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public abstract class PublishToGitHubPages
extends DefaultTask {
    @InputDirectory
    public abstract DirectoryProperty getPublishDirectory();

    @Internal
    public abstract Property<PasswordCredentials> getCredentials();

    @Input
    public abstract Property<URI> getUri();

    @Inject
    protected abstract FileSystemOperations getFileOperations();

    @TaskAction
    private void doPublish() throws GitAPIException, IOException {
        File repositoryDirectory = new File(this.getTemporaryDir(), BigInteger.valueOf(Hashing.md5().hashString((CharSequence)((URI)this.getUri().get()).toString(), Charset.defaultCharset()).asLong()).toString(36));
        repositoryDirectory.mkdirs();
        GitHubRepositoryUtils.createOrFetchOrClone(repositoryDirectory, (URI)this.getUri().get());
        this.getFileOperations().sync(spec -> {
            spec.into((Object)repositoryDirectory);
            spec.from(new Object[]{this.getPublishDirectory()});
        });
        GitHubRepositoryUtils.commitAndPushAllFiles(repositoryDirectory, (PasswordCredentials)this.getCredentials().getOrNull());
    }
}

