/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import dev.amp.validator.Context;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.ParsedDocCssSpec;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class InvalidDeclVisitor
implements RuleVisitor {
    private final ParsedDocCssSpec spec;
    private final Context context;
    private final ValidatorProtos.ValidationResult.Builder result;

    public InvalidDeclVisitor(@Nonnull ParsedDocCssSpec spec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        this.spec = spec;
        this.context = context;
        this.result = result;
    }

    @Override
    public void visitDeclaration(Declaration declaration) {
        if (this.spec.getCssDeclarationByName().get(declaration.getName()) != null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(declaration.getName());
            params.add("style amp-custom");
            this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_PROPERTY_NOLIST, this.context.getLineCol().getLineNumber() + declaration.getLine(), this.context.getLineCol().getColumnNumber() + declaration.getCol(), params, this.spec.getSpec().getSpecUrl(), this.result);
        }
    }
}

