/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import dev.amp.validator.SrcsetParsingResult;
import dev.amp.validator.SrcsetSourceDef;
import dev.amp.validator.ValidatorProtos;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class ParseSrcSetUtils {
    private static final Pattern IMAGE_CANDIDATE_REGEX = Pattern.compile("\\s*(?:,\\s*)?([^,\\s]\\S*[^,\\s])\\s*([\\d]+.?[\\d]*[w|x])?\\s*(?:(,)\\s*)?");

    private ParseSrcSetUtils() {
    }

    public static SrcsetParsingResult parseSrcset(@Nonnull String srcset) {
        String remainingSrcset = srcset;
        HashSet<String> seenWidthOrPixelDensity = new HashSet<String>();
        SrcsetParsingResult result = new SrcsetParsingResult();
        Matcher matcher = IMAGE_CANDIDATE_REGEX.matcher(srcset);
        while (matcher.find()) {
            String url = matcher.group(1);
            String widthOrPixelDensity = matcher.group(2);
            String comma = matcher.group(3);
            if (widthOrPixelDensity == null) {
                widthOrPixelDensity = "1x";
            }
            if (seenWidthOrPixelDensity.contains(widthOrPixelDensity)) {
                result.setErrorCode(ValidatorProtos.ValidationError.Code.DUPLICATE_DIMENSION);
                return result;
            }
            seenWidthOrPixelDensity.add(widthOrPixelDensity);
            result.add(new SrcsetSourceDef(url, widthOrPixelDensity));
            if (comma != null) continue;
            result.setErrorCode(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE);
            return result;
        }
        if (result.getSrcsetImagesSize() == 0) {
            result.setErrorCode(ValidatorProtos.ValidationError.Code.INVALID_ATTR_VALUE);
            return result;
        }
        result.setSuccess(true);
        return result;
    }
}

