/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.Context;
import dev.amp.validator.UrlErrorAdapter;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class UrlErrorInAttrAdapter
implements UrlErrorAdapter {
    private final String attrName;

    public UrlErrorInAttrAdapter(@Nonnull String attrName) {
        this.attrName = attrName;
    }

    @Override
    public void missingUrl(@Nonnull Context context, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.attrName);
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        context.addError(ValidatorProtos.ValidationError.Code.MISSING_URL, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }

    @Override
    public void invalidUrl(@Nonnull Context context, @Nonnull String url, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.attrName);
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        params.add(url);
        context.addError(ValidatorProtos.ValidationError.Code.INVALID_URL, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }

    @Override
    public void invalidUrlProtocol(@Nonnull Context context, @Nonnull String protocol, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.attrName);
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        params.add(protocol);
        context.addError(ValidatorProtos.ValidationError.Code.INVALID_URL_PROTOCOL, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }

    @Override
    public void disallowedRelativeUrl(@Nonnull Context context, @Nonnull String url, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.attrName);
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        params.add(url);
        context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_RELATIVE_URL, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }
}

