/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.staging.processes.web.internal.portlet.action;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationFactory;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationHelper;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.taglib.ui.util.SessionTreeJSClicks;
import com.liferay.trash.kernel.service.TrashEntryService;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_staging_processes_web_portlet_StagingProcessesPortlet", "mvc.command.name=editPublishConfiguration"}, service={MVCActionCommand.class})
public class EditPublishConfigurationMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditPublishConfigurationMVCActionCommand.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    private ExportImportConfigurationService _exportImportConfigurationService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;
    private TrashEntryService _trashEntryService;

    protected void deleteExportImportConfiguration(ActionRequest actionRequest, boolean moveToTrash) throws PortalException {
        long[] deleteExportImportConfigurationIds = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        deleteExportImportConfigurationIds = exportImportConfigurationId > 0L ? new long[]{exportImportConfigurationId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteExportImportConfigurationIds"), (long)0L);
        ArrayList<ExportImportConfiguration> trashedModels = new ArrayList<ExportImportConfiguration>();
        for (long deleteExportImportConfigurationId : deleteExportImportConfigurationIds) {
            if (moveToTrash) {
                ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationService.moveExportImportConfigurationToTrash(deleteExportImportConfigurationId);
                trashedModels.add(exportImportConfiguration);
                continue;
            }
            this._exportImportConfigurationService.deleteExportImportConfiguration(deleteExportImportConfigurationId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.setLayoutIdMap(actionRequest);
                this.updatePublishConfiguration(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteExportImportConfiguration(actionRequest, true);
            } else if (cmd.equals("relaunch")) {
                this.relaunchPublishLayoutConfiguration(themeDisplay.getUserId(), actionRequest);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
    }

    protected void relaunchPublishLayoutConfiguration(long userId, ActionRequest actionRequest) throws PortalException {
        long backgroundTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"backgroundTaskId");
        BackgroundTask backgroundTask = this._backgroundTaskManager.getBackgroundTask(backgroundTaskId);
        Map taskContextMap = backgroundTask.getTaskContextMap();
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId"));
        if ((exportImportConfiguration = ExportImportConfigurationFactory.cloneExportImportConfiguration((ExportImportConfiguration)exportImportConfiguration)).getType() == 1) {
            this._staging.publishLayouts(userId, exportImportConfiguration);
        } else if (exportImportConfiguration.getType() == 2) {
            this._staging.copyRemoteLayouts(exportImportConfiguration);
        }
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationService(ExportImportConfigurationService exportImportConfigurationService) {
        this._exportImportConfigurationService = exportImportConfigurationService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    protected void setLayoutIdMap(ActionRequest actionRequest) {
        HttpServletRequest portletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        String treeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"treeId");
        String openNodes = SessionTreeJSClicks.getOpenNodes((HttpServletRequest)portletRequest, (String)(treeId + "SelectedNode"));
        String selectedLayoutsJSON = this._exportImportHelper.getSelectedLayoutsJSON(groupId, privateLayout, openNodes);
        actionRequest.setAttribute("layoutIdMap", (Object)selectedLayoutsJSON);
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected void unsetExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = null;
    }

    protected ExportImportConfiguration updatePublishConfiguration(ActionRequest actionRequest) throws Exception {
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group.isStagedRemotely()) {
            if (exportImportConfigurationId > 0L) {
                return ExportImportConfigurationHelper.updatePublishLayoutRemoteExportImportConfiguration((PortletRequest)actionRequest);
            }
            return ExportImportConfigurationHelper.addPublishLayoutRemoteExportImportConfiguration((PortletRequest)actionRequest);
        }
        if (exportImportConfigurationId > 0L) {
            return ExportImportConfigurationHelper.updatePublishLayoutLocalExportImportConfiguration((PortletRequest)actionRequest);
        }
        return ExportImportConfigurationHelper.addPublishLayoutLocalExportImportConfiguration((PortletRequest)actionRequest);
    }
}

