/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.Dom4JUtil;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class DefinitionPoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "definition";
    private static final String _POSHI_SCRIPT_KEYWORD = "definition";
    private static final Pattern _blockNamePattern = Pattern.compile("^(@.*=.*|)definition", 32);
    private URL _filePathURL;
    private Boolean _validPoshiXML;

    @Override
    public PoshiElement clone(Element element) {
        return this.clone(element, null);
    }

    public PoshiElement clone(Element element, URL url) {
        if (this.isElementType(this.getElementName(), element)) {
            return new DefinitionPoshiElement(element, url);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        return this.clone(poshiScript, null);
    }

    public PoshiElement clone(String poshiScript, URL url) throws PoshiScriptParserException {
        if (this.isElementType(poshiScript)) {
            return new DefinitionPoshiElement(poshiScript, url);
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        URL filePathURL = this.getFilePathURL();
        String filePath = filePathURL.getPath();
        int index = filePath.lastIndexOf(".");
        return filePath.substring(index + 1);
    }

    @Override
    public URL getFilePathURL() {
        return this._filePathURL;
    }

    @Override
    public int getPoshiScriptLineNumber() {
        return this.getPoshiScriptLineNumber(false);
    }

    @Override
    public boolean isValidPoshiXML() throws PoshiScriptParserException {
        if (this._validPoshiXML == null) {
            String poshiScript;
            PoshiNode<?, ?> generatedPoshiNode;
            this._validPoshiXML = false;
            URL filePathURL = this.getFilePathURL();
            PoshiNode<?, ?> poshiNode = PoshiNodeFactory.newPoshiNodeFromFile(filePathURL);
            if (Dom4JUtil.elementsEqual(poshiNode, generatedPoshiNode = PoshiNodeFactory.newPoshiNode(poshiScript = poshiNode.toPoshiScript(), filePathURL))) {
                this._validPoshiXML = true;
            }
        }
        return this._validPoshiXML;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        Matcher poshiScriptAnnotationMatcher = poshiScriptAnnotationPattern.matcher(this.getBlockName(poshiScript));
        while (poshiScriptAnnotationMatcher.find()) {
            String annotation = poshiScriptAnnotationMatcher.group();
            String name = this.getNameFromAssignment(annotation);
            String value = this.getDoubleQuotedContent(annotation);
            this.addAttribute(name, value);
        }
        String blockContent = this.getBlockContent(poshiScript);
        for (String poshiScriptSnippet : this.getPoshiScriptSnippets(blockContent)) {
            this.add(PoshiNodeFactory.newPoshiNode(this, poshiScriptSnippet));
        }
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributeList())) {
            sb.append("\n@");
            sb.append(poshiElementAttribute.toPoshiScript());
        }
        sb.append(this.createPoshiScriptBlock(this.getPoshiNodes()));
        String string = sb.toString();
        return string.trim();
    }

    protected DefinitionPoshiElement() {
        super("definition");
    }

    protected DefinitionPoshiElement(Element element, URL url) {
        super("definition", element, url);
    }

    protected DefinitionPoshiElement(List<Attribute> attributes, List<Node> nodes) {
        super("definition", attributes, nodes);
    }

    protected DefinitionPoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super("definition", parentPoshiElement, poshiScript);
    }

    protected DefinitionPoshiElement(String poshiScript, URL url) throws PoshiScriptParserException {
        super("definition", null, poshiScript, url);
    }

    @Override
    protected String getBlockName() {
        return "definition";
    }

    protected String getElementName() {
        return "definition";
    }

    @Override
    protected String getPad() {
        return "";
    }

    @Override
    protected String getPoshiScriptKeyword() {
        String fileExtension = this.getFileExtension();
        if (fileExtension.equals("testcase")) {
            return "test";
        }
        return fileExtension;
    }

    protected boolean isElementType(String poshiScript) {
        return this.isValidPoshiScriptBlock(_blockNamePattern, poshiScript);
    }

    @Override
    protected void setFilePathURL(URL filePathURL) {
        this._filePathURL = filePathURL;
    }
}

