/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiElementAttribute;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.elements.PoshiNodeFactory;
import com.liferay.poshi.core.elements.ReturnPoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.RegexUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class ExecutePoshiElement
extends PoshiElement {
    private static final String _ELEMENT_NAME = "execute";
    private static final String _UTILITY_INVOCATION_REGEX = "(echo|fail|takeScreenshot)\\(.*?\\)";
    private static final Pattern _executeParameterPattern = Pattern.compile("^[\\s]*(\\w*\\s*=\\s*\"[ \\t\\S]*?\"|\\w*\\s*=\\s*'''.*?'''|\\w*\\s=\\s*[\\w\\.]*\\(.*?\\))[\\s]*$", 32);
    private static final List<String> _functionAttributeNames = Arrays.asList("locator1", "locator2", "value1", "value2");
    private static final Pattern _statementPattern = Pattern.compile("^" + INVOCATION_REGEX + ";$", 32);
    private static final Pattern _utilityInvocationStatementPattern = Pattern.compile("^(echo|fail|takeScreenshot)\\(.*?\\);$");

    @Override
    public PoshiElement clone(Element element) {
        if (this.isElementType(_ELEMENT_NAME, element)) {
            return new ExecutePoshiElement(element);
        }
        return null;
    }

    @Override
    public PoshiElement clone(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        if (this._isElementType(parentPoshiElement, poshiScript)) {
            return new ExecutePoshiElement(parentPoshiElement, poshiScript);
        }
        return null;
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        String poshiScriptParentheticalContent = this.getParentheticalContent(poshiScript);
        String fileExtension = this.getFileExtension();
        if (fileExtension.equals("function") && poshiScript.startsWith("selenium.")) {
            this.addAttribute("selenium", this.getCommandName(poshiScript));
            List<String> methodParameters = this.getMethodParameters(poshiScriptParentheticalContent);
            for (int i = 0; i < methodParameters.size(); ++i) {
                String methodParameter = methodParameters.get(i);
                String value = this.getDoubleQuotedContent(methodParameter);
                this.addAttribute("argument" + (i + 1), value);
            }
            return;
        }
        if (this.isValidUtilityClassName(poshiScript)) {
            this.addAttribute("class", this.getClassName(poshiScript));
            this.addAttribute("method", this.getCommandName(poshiScript));
            if (!PoshiContext.ignoreUtilClassesErrors()) {
                List<String> methodParameters = this.getMethodParameters(poshiScriptParentheticalContent);
                for (String methodParameter : methodParameters) {
                    this.add(PoshiNodeFactory.newPoshiNode(this, methodParameter));
                }
            }
            return;
        }
        String executeCommandName = RegexUtil.getGroup(poshiScript, "([^\\s]*?)\\(", 1);
        boolean namespacedCommandName = false;
        for (String namespace : PoshiContext.getNamespaces()) {
            if (!executeCommandName.startsWith(namespace + ".")) continue;
            namespacedCommandName = true;
            break;
        }
        if (namespacedCommandName) {
            String namespace;
            int index = executeCommandName.indexOf(".");
            namespace = executeCommandName.substring(0, index);
            executeCommandName = StringUtil.replace(executeCommandName, namespace + ".", "");
            executeCommandName = StringUtil.replace(executeCommandName, '.', '#');
            executeCommandName = namespace + "." + executeCommandName;
        } else {
            executeCommandName = StringUtil.replace(executeCommandName, '.', '#');
        }
        if (fileExtension.equals("function") || this.isValidFunctionFileName(poshiScript)) {
            this.addAttribute("function", executeCommandName);
        } else {
            PoshiNode<?, ?> returnPoshiNode;
            this.addAttribute("macro", executeCommandName);
            if (poshiScript.startsWith("var ") && (returnPoshiNode = PoshiNodeFactory.newPoshiNode(this, poshiScript)) instanceof ReturnPoshiElement) {
                this.add(returnPoshiNode);
            }
        }
        for (String parameter : this.getMethodParameters(poshiScriptParentheticalContent, _executeParameterPattern)) {
            parameter = parameter.trim();
            boolean functionAttributeAdded = false;
            for (String functionAttributeName : _functionAttributeNames) {
                if (!parameter.startsWith(functionAttributeName)) continue;
                String name = this.getNameFromAssignment(parameter);
                String value = this.getDoubleQuotedContent(parameter);
                value = StringEscapeUtils.unescapeXml((String)value);
                this.add((Attribute)new PoshiElementAttribute(name, value, parameter));
                functionAttributeAdded = true;
                break;
            }
            if (functionAttributeAdded) continue;
            this.add(PoshiNodeFactory.newPoshiNode(this, parameter));
        }
    }

    @Override
    public String toPoshiScript() {
        ArrayList<String> assignments = new ArrayList<String>();
        for (PoshiElementAttribute poshiElementAttribute : this.toPoshiElementAttributes(this.attributes())) {
            String poshiElementAttributeName = poshiElementAttribute.getName();
            if (poshiElementAttributeName.equals("class") || poshiElementAttributeName.equals("function") || poshiElementAttributeName.equals("macro") || poshiElementAttributeName.equals("method") || poshiElementAttributeName.equals("selenium")) continue;
            String fileExtension = this.getFileExtension();
            if (fileExtension.equals("function") && Validator.isNotNull(this.attributeValue("selenium"))) {
                String poshiElementAttributeValue = poshiElementAttribute.getValue();
                assignments.add(this.doubleQuoteContent(poshiElementAttributeValue));
                continue;
            }
            String poshiScript = poshiElementAttribute.toPoshiScript();
            assignments.add(poshiScript.trim());
        }
        ReturnPoshiElement returnPoshiElement = null;
        for (PoshiElement poshiElement : this.toPoshiElements(this.elements())) {
            if (poshiElement instanceof ReturnPoshiElement) {
                returnPoshiElement = (ReturnPoshiElement)poshiElement;
                continue;
            }
            String poshiScript = poshiElement.toPoshiScript();
            assignments.add(poshiScript.trim());
        }
        String string = this.createPoshiScriptSnippet(assignments);
        if (returnPoshiElement == null) {
            return string;
        }
        return returnPoshiElement.createPoshiScriptSnippet(string);
    }

    protected ExecutePoshiElement() {
        this(_ELEMENT_NAME);
    }

    protected ExecutePoshiElement(Element element) {
        super(_ELEMENT_NAME, element);
    }

    protected ExecutePoshiElement(List<Attribute> attributes, List<Node> nodes) {
        this(_ELEMENT_NAME, attributes, nodes);
    }

    protected ExecutePoshiElement(PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(_ELEMENT_NAME, parentPoshiElement, poshiScript);
    }

    protected ExecutePoshiElement(String name) {
        super(name);
    }

    protected ExecutePoshiElement(String name, Element element) {
        super(name, element);
    }

    protected ExecutePoshiElement(String elementName, List<Attribute> attributes, List<Node> nodes) {
        super(elementName, attributes, nodes);
    }

    protected ExecutePoshiElement(String name, PoshiElement parentPoshiElement, String poshiScript) throws PoshiScriptParserException {
        super(name, parentPoshiElement, poshiScript);
    }

    protected String createPoshiScriptSnippet(List<String> assignments) {
        StringBuilder sb = new StringBuilder();
        String blockName = this.getBlockName();
        String pad = this.getPad();
        sb.append("\n\n");
        sb.append(pad);
        sb.append(StringUtil.replace(blockName, '#', '.'));
        sb.append("(");
        boolean multilineSnippet = false;
        String assignmentsString = assignments.toString();
        int invocationStringLength = blockName.length() + assignmentsString.length();
        if (invocationStringLength > 80 && !this.isConditionValidInParent((PoshiElement)this.getParent())) {
            multilineSnippet = true;
        }
        for (String assignment : assignments) {
            if (multilineSnippet) {
                sb.append("\n\t");
                sb.append(pad);
            }
            sb.append(assignment);
            sb.append(",");
            if (multilineSnippet) continue;
            sb.append(" ");
        }
        if (!assignments.isEmpty()) {
            sb.setLength(sb.length() - 1);
            if (!multilineSnippet) {
                sb.setLength(sb.length() - 1);
            }
        }
        if (multilineSnippet) {
            sb.append("\n");
            sb.append(pad);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    protected String getBlockName() {
        if (this.attributeValue("class") != null) {
            return this.attributeValue("class") + "." + this.attributeValue("method");
        }
        if (this.attributeValue("function") != null) {
            return this.attributeValue("function");
        }
        if (this.attributeValue("macro") != null) {
            return this.attributeValue("macro");
        }
        return "selenium." + this.attributeValue("selenium");
    }

    private boolean _isElementType(PoshiElement parentPoshiElement, String poshiScript) {
        if (parentPoshiElement instanceof ExecutePoshiElement) {
            return false;
        }
        if ((this.isVarAssignedToMacroInvocation(poshiScript) || this.isValidPoshiScriptStatement(_statementPattern, poshiScript)) && !this.isValidPoshiScriptStatement(_utilityInvocationStatementPattern, poshiScript)) {
            return this.isBalancedPoshiScript(this.getParentheticalContent(poshiScript));
        }
        return false;
    }
}

