/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiVariablesUtil {
    private static Map<String, Object> _commandMap = new HashMap<String, Object>();
    private static final Stack<Map<String, Object>> _commandMapStack = new Stack();
    private static Map<String, Object> _executeMap = new HashMap<String, Object>();
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Map<String, Object> _staticMap = new HashMap<String, Object>();

    public static void clear() {
        _commandMap.clear();
        _commandMapStack.clear();
        _executeMap.clear();
        _staticMap.clear();
    }

    public static boolean containsKeyInCommandMap(String key) {
        return _commandMap.containsKey(PoshiVariablesUtil.replaceCommandVars(key));
    }

    public static boolean containsKeyInExecuteMap(String key) {
        return _executeMap.containsKey(PoshiVariablesUtil.replaceCommandVars(key));
    }

    public static boolean containsKeyInStaticMap(String key) {
        return _staticMap.containsKey(PoshiVariablesUtil.replaceCommandVars(key));
    }

    public static String getReplacedCommandVarsString(String token) {
        if (token == null) {
            return null;
        }
        Object tokenObject = PoshiVariablesUtil.replaceCommandVars(token);
        return tokenObject.toString();
    }

    public static String getStringFromCommandMap(String key) {
        if (PoshiVariablesUtil.containsKeyInCommandMap((String)PoshiVariablesUtil.replaceCommandVars(key))) {
            Object object = PoshiVariablesUtil.getValueFromCommandMap(key);
            return object.toString();
        }
        return null;
    }

    public static String getStringFromExecuteMap(String key) {
        if (PoshiVariablesUtil.containsKeyInExecuteMap((String)PoshiVariablesUtil.replaceCommandVars(key))) {
            Object object = PoshiVariablesUtil.getValueFromExecuteMap(key);
            return object.toString();
        }
        return null;
    }

    public static String getStringFromStaticMap(String key) {
        if (PoshiVariablesUtil.containsKeyInStaticMap((String)PoshiVariablesUtil.replaceStaticVars(key))) {
            Object object = PoshiVariablesUtil.getValueFromExecuteMap(key);
            return object.toString();
        }
        return null;
    }

    public static Object getValueFromCommandMap(String key) {
        return _commandMap.get(PoshiVariablesUtil.replaceCommandVars(key));
    }

    public static Object getValueFromExecuteMap(String key) {
        return _executeMap.get(PoshiVariablesUtil.replaceCommandVars(key));
    }

    public static Object getValueFromStaticMap(String key) {
        return _staticMap.get(PoshiVariablesUtil.replaceCommandVars(key));
    }

    public static void popCommandMap() {
        _commandMap = _commandMapStack.pop();
        _commandMap.putAll(_staticMap);
        _executeMap = new HashMap<String, Object>();
    }

    public static void pushCommandMap() {
        _commandMapStack.push(_commandMap);
        _commandMap = _executeMap;
        _commandMap.putAll(_staticMap);
        _executeMap = new HashMap<String, Object>();
    }

    public static void putIntoCommandMap(String key, Object value) {
        if (value instanceof String) {
            _commandMap.put((String)PoshiVariablesUtil.replaceCommandVars(key), PoshiVariablesUtil.replaceCommandVars((String)value));
        } else {
            _commandMap.put((String)PoshiVariablesUtil.replaceCommandVars(key), value);
        }
        if (PoshiVariablesUtil.containsKeyInStaticMap(key)) {
            PoshiVariablesUtil.putIntoStaticMap(key, value);
        }
    }

    public static void putIntoExecuteMap(String key, Object value) {
        if (value instanceof String) {
            _executeMap.put((String)PoshiVariablesUtil.replaceCommandVars(key), PoshiVariablesUtil.replaceCommandVars((String)value));
        } else {
            _executeMap.put((String)PoshiVariablesUtil.replaceCommandVars(key), value);
        }
    }

    public static void putIntoStaticMap(String key, Object value) {
        if (value instanceof String) {
            _staticMap.put((String)PoshiVariablesUtil.replaceCommandVars(key), PoshiVariablesUtil.replaceCommandVars((String)value));
        } else {
            _staticMap.put((String)PoshiVariablesUtil.replaceCommandVars(key), value);
        }
    }

    public static Object replaceCommandVars(String token) {
        Matcher matcher = _pattern.matcher(token);
        if (matcher.matches() && _commandMap.containsKey(matcher.group(1))) {
            return PoshiVariablesUtil.getValueFromCommandMap(matcher.group(1));
        }
        matcher.reset();
        while (matcher.find() && _commandMap.containsKey(matcher.group(1))) {
            String varValue = PoshiVariablesUtil.getStringFromCommandMap(matcher.group(1));
            token = StringUtil.replace(token, matcher.group(), varValue);
        }
        return token;
    }

    public static Object replaceExecuteVars(String token) {
        Matcher matcher = _pattern.matcher(token);
        if (matcher.matches() && _executeMap.containsKey(matcher.group(1))) {
            return PoshiVariablesUtil.getValueFromExecuteMap(matcher.group(1));
        }
        matcher.reset();
        while (matcher.find() && _executeMap.containsKey(matcher.group(1))) {
            String varValue = PoshiVariablesUtil.getStringFromExecuteMap(matcher.group(1));
            token = StringUtil.replace(token, matcher.group(), varValue);
        }
        return token;
    }

    public static Object replaceStaticVars(String token) {
        Matcher matcher = _pattern.matcher(token);
        if (matcher.matches() && _staticMap.containsKey(matcher.group(1))) {
            return PoshiVariablesUtil.getValueFromStaticMap(matcher.group(1));
        }
        matcher.reset();
        while (matcher.find() && _staticMap.containsKey(matcher.group(1))) {
            String varValue = PoshiVariablesUtil.getStringFromStaticMap(matcher.group(1));
            token = StringUtil.replace(token, matcher.group(), varValue);
        }
        return token;
    }
}

