/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.output.stream.container.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactoryTracker;
import com.liferay.portal.output.stream.container.internal.ConsoleOutputStreamContainerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={OutputStreamContainerFactoryTracker.class})
public class OutputStreamContainerFactoryTrackerImpl
implements OutputStreamContainerFactoryTracker {
    private final OutputStreamContainerFactory _consoleOutputStreamContainerFactory = new ConsoleOutputStreamContainerFactory();
    private org.apache.felix.utils.log.Logger _logger;
    private ServiceTrackerMap<String, OutputStreamContainerFactory> _outputStreamContainerFactories;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile OutputStreamContainerFactory _outputStreamContainerFactory;
    private WriterAppender _writerAppender;
    private final ThreadLocal<Writer> _writerThreadLocal = new ThreadLocal();

    public OutputStreamContainerFactory getOutputStreamContainerFactory() {
        OutputStreamContainerFactory outputStreamContainerFactory = this._outputStreamContainerFactory;
        if (outputStreamContainerFactory != null) {
            return outputStreamContainerFactory;
        }
        return this._consoleOutputStreamContainerFactory;
    }

    public OutputStreamContainerFactory getOutputStreamContainerFactory(String outputStreamContainerFactoryName) {
        OutputStreamContainerFactory outputStreamContainerFactory = (OutputStreamContainerFactory)this._outputStreamContainerFactories.getService((Object)outputStreamContainerFactoryName);
        if (outputStreamContainerFactory == null) {
            throw new IllegalArgumentException("No output stream container factory registered with name " + outputStreamContainerFactoryName);
        }
        return outputStreamContainerFactory;
    }

    public Set<String> getOutputStreamContainerFactoryNames() {
        return this._outputStreamContainerFactories.keySet();
    }

    public void runWithSwappedLog(Runnable runnable, String outputStreamHint) {
        OutputStreamContainerFactory outputStreamContainerFactory = this.getOutputStreamContainerFactory();
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create(outputStreamHint);
        this.runWithSwappedLog(runnable, outputStreamContainer.getDescription(), outputStreamContainer.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSwappedLog(Runnable runnable, String outputStreamName, OutputStream outputStream) {
        this._logger.log(3, "Using " + outputStreamName + " as output");
        Writer writer = this._writerThreadLocal.get();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        this._writerThreadLocal.set(outputStreamWriter);
        try {
            runnable.run();
        }
        finally {
            this._writerThreadLocal.set(writer);
            try {
                outputStreamWriter.flush();
            }
            catch (IOException ioe) {
                this._logger.log(1, ioe.getLocalizedMessage());
            }
        }
    }

    public void runWithSwappedLog(Runnable runnable, String outputStreamHint, String outputStreamContainerName) {
        OutputStreamContainerFactory outputStreamContainerFactory = (OutputStreamContainerFactory)this._outputStreamContainerFactories.getService((Object)outputStreamContainerName);
        if (outputStreamContainerFactory == null) {
            this.runWithSwappedLog(runnable, outputStreamHint);
            return;
        }
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create(outputStreamHint);
        this.runWithSwappedLog(runnable, outputStreamContainer.getDescription(), outputStreamContainer.getOutputStream());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._logger = new org.apache.felix.utils.log.Logger(bundleContext);
        Logger rootLogger = Logger.getRootLogger();
        this._writerAppender = new WriterAppender((Layout)new SimpleLayout(), (Writer)new ThreadLocalWriter());
        this._writerAppender.setThreshold((Priority)Level.ALL);
        this._writerAppender.activateOptions();
        rootLogger.addAppender((Appender)this._writerAppender);
        this._outputStreamContainerFactories = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, OutputStreamContainerFactory.class, (String)"name");
    }

    @Deactivate
    protected void deactivate() {
        Logger rootLogger = Logger.getRootLogger();
        if (this._outputStreamContainerFactories != null) {
            this._outputStreamContainerFactories.close();
        }
        if (rootLogger != null) {
            rootLogger.removeAppender((Appender)this._writerAppender);
        }
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private class ThreadLocalWriter
    extends Writer {
        private ThreadLocalWriter() {
        }

        @Override
        public void close() throws IOException {
            Writer writer = (Writer)OutputStreamContainerFactoryTrackerImpl.this._writerThreadLocal.get();
            if (writer != null) {
                writer.close();
            }
        }

        @Override
        public void flush() throws IOException {
            Writer writer = (Writer)OutputStreamContainerFactoryTrackerImpl.this._writerThreadLocal.get();
            if (writer != null) {
                writer.flush();
            }
        }

        @Override
        public void write(char[] chars, int offset, int length) throws IOException {
            Writer writer = (Writer)OutputStreamContainerFactoryTrackerImpl.this._writerThreadLocal.get();
            if (writer != null) {
                writer.write(chars, offset, length);
            }
        }
    }
}

