/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.delivery.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.AggregateRating;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.delivery.dto.v1_0.CustomField;
import com.liferay.headless.delivery.dto.v1_0.RelatedContent;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlRootElement;

@GraphQLName(value="MessageBoardThread")
@JsonFilter(value="Liferay.Vulcan")
@Schema(requiredProperties={"headline"})
@XmlRootElement(name="MessageBoardThread")
public class MessageBoardThread {
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected AggregateRating aggregateRating;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String articleBody;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Creator creator;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected CustomField[] customFields;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateCreated;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Date dateModified;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected String encodingFormat;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected String headline;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long id;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String[] keywords;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfMessageBoardAttachments;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer numberOfMessageBoardMessages;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected RelatedContent[] relatedContents;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected Boolean showAsQuestion;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Long siteId;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected String threadType;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Integer viewCount;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected ViewableBy viewableBy;

    @Schema(description="The thread's average rating.")
    public AggregateRating getAggregateRating() {
        return this.aggregateRating;
    }

    public void setAggregateRating(AggregateRating aggregateRating) {
        this.aggregateRating = aggregateRating;
    }

    @JsonIgnore
    public void setAggregateRating(UnsafeSupplier<AggregateRating, Exception> aggregateRatingUnsafeSupplier) {
        try {
            this.aggregateRating = (AggregateRating)aggregateRatingUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's main body content (the message written as the thread's description).")
    public String getArticleBody() {
        return this.articleBody;
    }

    public void setArticleBody(String articleBody) {
        this.articleBody = articleBody;
    }

    @JsonIgnore
    public void setArticleBody(UnsafeSupplier<String, Exception> articleBodyUnsafeSupplier) {
        try {
            this.articleBody = (String)articleBodyUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's creator.")
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        try {
            this.creator = (Creator)creatorUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    @JsonIgnore
    public void setCustomFields(UnsafeSupplier<CustomField[], Exception> customFieldsUnsafeSupplier) {
        try {
            this.customFields = (CustomField[])customFieldsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The date the thread was created.")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        try {
            this.dateCreated = (Date)dateCreatedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The last time any field of the thread changed.")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        try {
            this.dateModified = (Date)dateModifiedUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The media format of the thread's content (e.g., HTML, BBCode, etc.).")
    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    @JsonIgnore
    public void setEncodingFormat(UnsafeSupplier<String, Exception> encodingFormatUnsafeSupplier) {
        try {
            this.encodingFormat = (String)encodingFormatUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's main title.")
    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    @JsonIgnore
    public void setHeadline(UnsafeSupplier<String, Exception> headlineUnsafeSupplier) {
        try {
            this.headline = (String)headlineUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's ID.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        try {
            this.id = (Long)idUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A list of keywords describing the thread.")
    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    @JsonIgnore
    public void setKeywords(UnsafeSupplier<String[], Exception> keywordsUnsafeSupplier) {
        try {
            this.keywords = (String[])keywordsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of the thread's attachments.")
    public Integer getNumberOfMessageBoardAttachments() {
        return this.numberOfMessageBoardAttachments;
    }

    public void setNumberOfMessageBoardAttachments(Integer numberOfMessageBoardAttachments) {
        this.numberOfMessageBoardAttachments = numberOfMessageBoardAttachments;
    }

    @JsonIgnore
    public void setNumberOfMessageBoardAttachments(UnsafeSupplier<Integer, Exception> numberOfMessageBoardAttachmentsUnsafeSupplier) {
        try {
            this.numberOfMessageBoardAttachments = (Integer)numberOfMessageBoardAttachmentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of the thread's messages.")
    public Integer getNumberOfMessageBoardMessages() {
        return this.numberOfMessageBoardMessages;
    }

    public void setNumberOfMessageBoardMessages(Integer numberOfMessageBoardMessages) {
        this.numberOfMessageBoardMessages = numberOfMessageBoardMessages;
    }

    @JsonIgnore
    public void setNumberOfMessageBoardMessages(UnsafeSupplier<Integer, Exception> numberOfMessageBoardMessagesUnsafeSupplier) {
        try {
            this.numberOfMessageBoardMessages = (Integer)numberOfMessageBoardMessagesUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema
    public RelatedContent[] getRelatedContents() {
        return this.relatedContents;
    }

    public void setRelatedContents(RelatedContent[] relatedContents) {
        this.relatedContents = relatedContents;
    }

    @JsonIgnore
    public void setRelatedContents(UnsafeSupplier<RelatedContent[], Exception> relatedContentsUnsafeSupplier) {
        try {
            this.relatedContents = (RelatedContent[])relatedContentsUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A flag that indicates whether this thread was posted as a question that can receive approved answers.")
    public Boolean getShowAsQuestion() {
        return this.showAsQuestion;
    }

    public void setShowAsQuestion(Boolean showAsQuestion) {
        this.showAsQuestion = showAsQuestion;
    }

    @JsonIgnore
    public void setShowAsQuestion(UnsafeSupplier<Boolean, Exception> showAsQuestionUnsafeSupplier) {
        try {
            this.showAsQuestion = (Boolean)showAsQuestionUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The ID of the site to which this thread is scoped.")
    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    @JsonIgnore
    public void setSiteId(UnsafeSupplier<Long, Exception> siteIdUnsafeSupplier) {
        try {
            this.siteId = (Long)siteIdUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The thread's type.")
    public String getThreadType() {
        return this.threadType;
    }

    public void setThreadType(String threadType) {
        this.threadType = threadType;
    }

    @JsonIgnore
    public void setThreadType(UnsafeSupplier<String, Exception> threadTypeUnsafeSupplier) {
        try {
            this.threadType = (String)threadTypeUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="The number of views of this thread.")
    public Integer getViewCount() {
        return this.viewCount;
    }

    public void setViewCount(Integer viewCount) {
        this.viewCount = viewCount;
    }

    @JsonIgnore
    public void setViewCount(UnsafeSupplier<Integer, Exception> viewCountUnsafeSupplier) {
        try {
            this.viewCount = (Integer)viewCountUnsafeSupplier.get();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Schema(description="A write-only property that specifies the thread's default permissions.")
    public ViewableBy getViewableBy() {
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        if (this.viewableBy == null) {
            return null;
        }
        return this.viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        try {
            this.viewableBy = (ViewableBy)((Object)viewableByUnsafeSupplier.get());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageBoardThread)) {
            return false;
        }
        MessageBoardThread messageBoardThread = (MessageBoardThread)object;
        return Objects.equals(this.toString(), messageBoardThread.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        if (this.aggregateRating != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"aggregateRating\": ");
            sb.append(String.valueOf(this.aggregateRating));
        }
        if (this.articleBody != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"articleBody\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.articleBody));
            sb.append("\"");
        }
        if (this.creator != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append(String.valueOf(this.creator));
        }
        if (this.customFields != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"customFields\": ");
            sb.append("[");
            for (i = 0; i < this.customFields.length; ++i) {
                sb.append(String.valueOf(this.customFields[i]));
                if (i + 1 >= this.customFields.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.dateCreated != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateCreated));
            sb.append("\"");
        }
        if (this.dateModified != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(this.dateModified));
            sb.append("\"");
        }
        if (this.encodingFormat != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"encodingFormat\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.encodingFormat));
            sb.append("\"");
        }
        if (this.headline != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"headline\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.headline));
            sb.append("\"");
        }
        if (this.id != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)this.id);
        }
        if (this.keywords != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"keywords\": ");
            sb.append("[");
            for (i = 0; i < this.keywords.length; ++i) {
                sb.append("\"");
                sb.append(MessageBoardThread._escape(this.keywords[i]));
                sb.append("\"");
                if (i + 1 >= this.keywords.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.numberOfMessageBoardAttachments != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfMessageBoardAttachments\": ");
            sb.append((Object)this.numberOfMessageBoardAttachments);
        }
        if (this.numberOfMessageBoardMessages != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfMessageBoardMessages\": ");
            sb.append((Object)this.numberOfMessageBoardMessages);
        }
        if (this.relatedContents != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"relatedContents\": ");
            sb.append("[");
            for (i = 0; i < this.relatedContents.length; ++i) {
                sb.append(String.valueOf(this.relatedContents[i]));
                if (i + 1 >= this.relatedContents.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if (this.showAsQuestion != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"showAsQuestion\": ");
            sb.append((Object)this.showAsQuestion);
        }
        if (this.siteId != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"siteId\": ");
            sb.append((Object)this.siteId);
        }
        if (this.threadType != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"threadType\": ");
            sb.append("\"");
            sb.append(MessageBoardThread._escape(this.threadType));
            sb.append("\"");
        }
        if (this.viewCount != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewCount\": ");
            sb.append((Object)this.viewCount);
        }
        if (this.viewableBy != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)this.viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        String string = String.valueOf(object);
        return string.replaceAll("\"", "\\\\\"");
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

