/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

_.mixin({
	bindKeyRight(context, key) {
		var args = _.toArray(arguments).slice(2);

		args.unshift(_.bindKey(context, key));

		return _.partialRight.apply(_, args);
	},

	bindRight(fn, context) {
		var args = _.toArray(arguments).slice(2);

		args.unshift(_.bind(fn, context));

		return _.partialRight.apply(_, args);
	},

	cached(fn) {
		return _.memoize(fn, function () {
			return arguments.length > 1
				? Array.prototype.join.call(arguments, '_')
				: String(arguments[0]);
		});
	},
});

_.mixin(
	{
		namespace(obj, path) {
			if (arguments.length === 1) {
				path = obj;
				obj = this;
			}

			if (_.isString(path)) {
				path = path.split('.');
			}

			for (var i = 0; i < path.length; i++) {
				var name = path[i];

				obj[name] = obj[name] || {};
				obj = obj[name];
			}

			return obj;
		},
	},
	{
		chain: false,
	}
);
