/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FragmentEntryConfigUtil {
    private static final String _CONTEXT_OBJECT_SUFFIX = "Object";
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryConfigUtil.class);

    public static JSONObject getConfigurationDefaultValuesJSONObject(String configuration) {
        List<FragmentConfigurationField> fragmentConfigurationFields = FragmentEntryConfigUtil.getFragmentConfigurationFields(configuration);
        JSONObject defaultValuesJSONObject = JSONFactoryUtil.createJSONObject();
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            defaultValuesJSONObject.put(fragmentConfigurationField.getName(), FragmentEntryConfigUtil.getFieldValue(fragmentConfigurationField, null));
        }
        return defaultValuesJSONObject;
    }

    public static Map<String, Object> getContextObjects(JSONObject configurationValuesJSONObject, String configuration) {
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        List<FragmentConfigurationField> fragmentConfigurationFields = FragmentEntryConfigUtil.getFragmentConfigurationFields(configuration);
        for (FragmentConfigurationField fragmentConfigurationField : fragmentConfigurationFields) {
            String name = fragmentConfigurationField.getName();
            Object contextObject = FragmentEntryConfigUtil._getContextObject(fragmentConfigurationField.getType(), configurationValuesJSONObject.getString(name));
            if (contextObject == null) continue;
            contextObjects.put(name + _CONTEXT_OBJECT_SUFFIX, contextObject);
        }
        return contextObjects;
    }

    public static Object getFieldValue(FragmentConfigurationField fragmentConfigurationField, String value) {
        value = GetterUtil.getString((String)value, (String)fragmentConfigurationField.getDefaultValue());
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"checkbox")) {
            return FragmentEntryConfigUtil._getFieldValue("bool", value);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"colorPalette")) {
            return FragmentEntryConfigUtil._getFieldValue("object", value);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"itemSelector")) {
            return FragmentEntryConfigUtil._getAssetEntryJSONObject(value);
        }
        if (StringUtil.equalsIgnoreCase((String)fragmentConfigurationField.getType(), (String)"select")) {
            String dataType = fragmentConfigurationField.getDataType();
            if (Validator.isNull((String)dataType)) {
                _log.error((Object)(fragmentConfigurationField.getName() + " field has an invalid data type"));
                return null;
            }
            return FragmentEntryConfigUtil._getFieldValue(dataType, value);
        }
        return FragmentEntryConfigUtil._getFieldValue("string", value);
    }

    @Deprecated
    public static Object getFieldValue(String configuration, String fieldName, String value) {
        throw new UnsupportedOperationException();
    }

    public static List<FragmentConfigurationField> getFragmentConfigurationFields(String configuration) {
        JSONArray fieldSetsJSONArray = FragmentEntryConfigUtil._getFieldSetsJSONArray(configuration);
        if (fieldSetsJSONArray == null) {
            return Collections.emptyList();
        }
        ArrayList<FragmentConfigurationField> fragmentConfigurationFields = new ArrayList<FragmentConfigurationField>();
        Iterator iteratorFieldSet = fieldSetsJSONArray.iterator();
        iteratorFieldSet.forEachRemaining(fieldSetJSONObject -> {
            JSONArray fieldSetFieldsJSONArray = fieldSetJSONObject.getJSONArray("fields");
            Iterator iteratorFieldSetFields = fieldSetFieldsJSONArray.iterator();
            iteratorFieldSetFields.forEachRemaining(fieldSetFieldsJSONObject -> fragmentConfigurationFields.add(new FragmentConfigurationField((JSONObject)fieldSetFieldsJSONObject)));
        });
        return fragmentConfigurationFields;
    }

    private static Object _getAssetEntry(String value) {
        block4: {
            if (Validator.isNull((String)value)) {
                return null;
            }
            try {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
                String className = GetterUtil.getString((String)jsonObject.getString("className"));
                long classPK = GetterUtil.getLong((String)jsonObject.getString("classPK"));
                AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
                if (assetEntry != null) {
                    AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
                    return assetRenderer.getAssetObject();
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("Unable to get asset entry: " + value), (Throwable)e);
            }
        }
        return null;
    }

    private static JSONObject _getAssetEntryJSONObject(String value) {
        if (Validator.isNull((String)value)) {
            return JSONFactoryUtil.createJSONObject();
        }
        try {
            JSONObject configurationValueJSONObject = JSONFactoryUtil.createJSONObject((String)value);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)FragmentEntryConfigUtil._getAssetEntry(value)));
            jsonObject.put("className", GetterUtil.getString((String)configurationValueJSONObject.getString("className"))).put("classNameId", GetterUtil.getString((String)configurationValueJSONObject.getString("classNameId"))).put("classPK", GetterUtil.getLong((String)configurationValueJSONObject.getString("classPK")));
            return jsonObject;
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to serialize asset entry to JSON: " + value), (Throwable)jsone);
            }
            return null;
        }
    }

    private static Object _getContextObject(String type, String value) {
        if (StringUtil.equalsIgnoreCase((String)type, (String)"itemSelector")) {
            return FragmentEntryConfigUtil._getAssetEntry(value);
        }
        return null;
    }

    private static JSONArray _getFieldSetsJSONArray(String configuration) {
        try {
            JSONObject configurationJSONObject = JSONFactoryUtil.createJSONObject((String)configuration);
            return configurationJSONObject.getJSONArray("fieldSets");
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse configuration JSON: " + configuration), (Throwable)jsone);
            }
            return null;
        }
    }

    private static Object _getFieldValue(String dataType, String value) {
        if (StringUtil.equalsIgnoreCase((String)dataType, (String)"bool")) {
            return GetterUtil.getBoolean((String)value);
        }
        if (StringUtil.equalsIgnoreCase((String)dataType, (String)"double")) {
            return GetterUtil.getDouble((String)value);
        }
        if (StringUtil.equalsIgnoreCase((String)dataType, (String)"int")) {
            return GetterUtil.getInteger((String)value);
        }
        if (StringUtil.equalsIgnoreCase((String)dataType, (String)"object")) {
            try {
                return JSONFactoryUtil.createJSONObject((String)value);
            }
            catch (JSONException jsone) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to parse configuration JSON: " + value), (Throwable)jsone);
                }
            }
        } else if (StringUtil.equalsIgnoreCase((String)dataType, (String)"string")) {
            return value;
        }
        return null;
    }
}

