/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.contributor;

import com.liferay.fragment.constants.FragmentConstants;
import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseFragmentCollectionContributor
implements FragmentCollectionContributor {
    @Reference
    protected FragmentEntryLinkLocalService fragmentEntryLinkLocalService;
    @Reference
    protected FragmentEntryLocalService fragmentEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseFragmentCollectionContributor.class);
    private Bundle _bundle;
    private final Map<Integer, List<FragmentEntry>> _fragmentEntries = new HashMap<Integer, List<FragmentEntry>>();
    private final Map<String, Map<Locale, String>> _fragmentEntryNames = new HashMap<String, Map<Locale, String>>();
    private Map<Locale, String> _names;

    @Override
    public List<FragmentEntry> getFragmentEntries(int type) {
        return this._fragmentEntries.getOrDefault(type, Collections.emptyList());
    }

    @Override
    public List<FragmentEntry> getFragmentEntries(int type, Locale locale) {
        List fragmentEntries = this._fragmentEntries.getOrDefault(type, Collections.emptyList());
        Stream stream = fragmentEntries.stream();
        return stream.map(fragmentEntry -> {
            Map names = this._fragmentEntryNames.getOrDefault(fragmentEntry.getFragmentEntryKey(), Collections.emptyMap());
            fragmentEntry.setName(names.getOrDefault(locale, names.getOrDefault(LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()), fragmentEntry.getName())));
            return fragmentEntry;
        }).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        return this._names.get(LocaleUtil.getDefault());
    }

    @Override
    public String getName(Locale locale) {
        String name = this._names.get(locale);
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        return this.getName();
    }

    @Override
    public ResourceBundleLoader getResourceBundleLoader() {
        ServletContext servletContext = this.getServletContext();
        return Optional.ofNullable(ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName((String)servletContext.getServletContextName())).orElse(ResourceBundleLoaderUtil.getPortalResourceBundleLoader());
    }

    public abstract ServletContext getServletContext();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
        this.readAndCheckFragmentCollectionStructure();
    }

    protected void readAndCheckFragmentCollectionStructure() {
        block4: {
            try {
                Map<Locale, String> names = this._getContributedCollectionNames();
                Enumeration enumeration = this._bundle.findEntries("", "fragment.json", true);
                if (MapUtil.isEmpty(names) || !enumeration.hasMoreElements()) {
                    return;
                }
                this._names = names;
                while (enumeration.hasMoreElements()) {
                    URL url = (URL)enumeration.nextElement();
                    FragmentEntry fragmentEntry = this._getFragmentEntry(url);
                    this._updateFragmentEntryLinks(fragmentEntry);
                    List fragmentEntryList = this._fragmentEntries.computeIfAbsent(fragmentEntry.getType(), type -> new ArrayList());
                    fragmentEntryList.add(fragmentEntry);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    private Map<Locale, String> _getContributedCollectionNames() throws Exception {
        Class<?> clazz = this.getClass();
        String json = StreamUtil.toString((InputStream)clazz.getResourceAsStream("dependencies/collection.json"));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        String name = jsonObject.getString("name");
        HashMap<Locale, String> names = new HashMap<Locale, String>();
        this._setLocalizedNames(name, names, this.getResourceBundleLoader());
        return names;
    }

    private FragmentEntry _getFragmentEntry(URL url) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StreamUtil.toString((InputStream)url.openStream()));
        String fragmentEntryKey = StringBundler.concat((String[])new String[]{this.getFragmentCollectionKey(), "-", jsonObject.getString("fragmentEntryKey")});
        Map names = this._fragmentEntryNames.getOrDefault(fragmentEntryKey, new HashMap());
        String name = jsonObject.getString("name");
        this._setLocalizedNames(name, names, this.getResourceBundleLoader());
        this._fragmentEntryNames.put(fragmentEntryKey, names);
        String path = FileUtil.getPath((String)url.getPath());
        String css = this._read(path, jsonObject.getString("cssPath"));
        String html = this._read(path, jsonObject.getString("htmlPath"));
        String js = this._read(path, jsonObject.getString("jsPath"));
        String configuration = this._read(path, jsonObject.getString("configurationPath"));
        String thumbnailURL = this._getImagePreviewURL(jsonObject.getString("thumbnail"));
        int type = FragmentConstants.getTypeFromLabel(jsonObject.getString("type"));
        FragmentEntry fragmentEntry = this.fragmentEntryLocalService.createFragmentEntry(0L);
        fragmentEntry.setFragmentEntryKey(fragmentEntryKey);
        fragmentEntry.setName(name);
        fragmentEntry.setCss(css);
        fragmentEntry.setHtml(html);
        fragmentEntry.setJs(js);
        fragmentEntry.setConfiguration(configuration);
        fragmentEntry.setType(type);
        fragmentEntry.setImagePreviewURL(thumbnailURL);
        return fragmentEntry;
    }

    private String _getImagePreviewURL(String fileName) {
        URL url = this._bundle.getResource("META-INF/resources/thumbnails/" + fileName);
        if (url == null) {
            return "";
        }
        ServletContext servletContext = this.getServletContext();
        return servletContext.getContextPath() + "/thumbnails/" + fileName;
    }

    private String _read(String path, String fileName) throws Exception {
        Class<?> clazz = this.getClass();
        StringBundler sb = new StringBundler(3);
        sb.append(path);
        sb.append("/");
        sb.append(fileName);
        return StringUtil.read((InputStream)clazz.getResourceAsStream(sb.toString()));
    }

    private void _setLocalizedNames(String name, Map<Locale, String> names, ResourceBundleLoader resourceBundleLoader) {
        HashSet<Locale> availableLocales = new HashSet<Locale>(LanguageUtil.getAvailableLocales());
        availableLocales.add(LocaleUtil.getDefault());
        for (Locale locale : availableLocales) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(LocaleUtil.fromLanguageId((String)languageId));
            if (!Validator.isNotNull((String)name)) continue;
            names.put(LocaleUtil.fromLanguageId((String)languageId), LanguageUtil.get((ResourceBundle)resourceBundle, (String)name, (String)name));
        }
    }

    private void _updateFragmentEntryLinks(FragmentEntry fragmentEntry) {
        List<FragmentEntryLink> fragmentEntryLinks = this.fragmentEntryLinkLocalService.getFragmentEntryLinks(fragmentEntry.getFragmentEntryKey());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            fragmentEntryLink.setCss(fragmentEntry.getCss());
            fragmentEntryLink.setHtml(fragmentEntry.getHtml());
            fragmentEntryLink.setJs(fragmentEntry.getJs());
            fragmentEntryLink.setConfiguration(fragmentEntry.getConfiguration());
            this.fragmentEntryLinkLocalService.updateFragmentEntryLink(fragmentEntryLink);
        }
    }
}

