/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.forms.apio.architect.identifier.StructureIdentifier;
import com.liferay.forms.apio.internal.helper.FormStructureRepresentorBuilderHelper;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameService;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NestedCollectionResource.class})
public class FormStructureNestedCollectionResource
implements NestedCollectionResource<DDMStructure, Long, StructureIdentifier, Long, ContentSpaceIdentifier> {
    @Reference
    private ClassNameService _classNameService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private FormStructureRepresentorBuilderHelper _formStructureRepresentorBuilderHelper;

    public NestedCollectionRoutes<DDMStructure, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<DDMStructure, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    public String getName() {
        return "form-structures";
    }

    public ItemRoutes<DDMStructure, Long> itemRoutes(ItemRoutes.Builder<DDMStructure, Long> builder) {
        return builder.addGetter(arg_0 -> ((DDMStructureLocalService)this._ddmStructureLocalService).getStructure(arg_0)).build();
    }

    public Representor<DDMStructure> representor(Representor.Builder<DDMStructure, Long> builder) {
        Representor.FirstStep<DDMStructure> ddmStructureFirstStep = this._formStructureRepresentorBuilderHelper.buildDDMStructureFirstStep(builder);
        return (Representor)ddmStructureFirstStep.build();
    }

    private PageItems<DDMStructure> _getPageItems(Pagination pagination, Long groupId) {
        ClassName className = this._classNameService.fetchClassName(DDMFormInstance.class.getName());
        List ddmStructures = this._ddmStructureLocalService.getStructures(groupId.longValue(), className.getClassNameId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._ddmStructureLocalService.getStructuresCount(groupId.longValue(), className.getClassNameId());
        return new PageItems((Collection)ddmStructures, count);
    }
}

