/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.forms.apio.internal.architect.resource;

import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.custom.actions.CustomRoute;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceModel;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersionModel;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.forms.apio.architect.identifier.FormContextIdentifier;
import com.liferay.forms.apio.architect.identifier.FormInstanceIdentifier;
import com.liferay.forms.apio.architect.identifier.FormInstanceRecordIdentifier;
import com.liferay.forms.apio.architect.identifier.StructureIdentifier;
import com.liferay.forms.apio.internal.architect.form.FetchLatestDraftForm;
import com.liferay.forms.apio.internal.architect.form.FormContextForm;
import com.liferay.forms.apio.internal.architect.form.MediaObjectCreatorForm;
import com.liferay.forms.apio.internal.architect.route.EvaluateContextRoute;
import com.liferay.forms.apio.internal.architect.route.FetchLatestDraftRoute;
import com.liferay.forms.apio.internal.architect.route.UploadFileRoute;
import com.liferay.forms.apio.internal.helper.EvaluateContextHelper;
import com.liferay.forms.apio.internal.helper.FetchLatestRecordHelper;
import com.liferay.forms.apio.internal.helper.UploadFileHelper;
import com.liferay.forms.apio.internal.model.FormContextWrapper;
import com.liferay.forms.apio.internal.util.FormInstanceRepresentorUtil;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.apio.user.CurrentUser;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.repository.model.FileEntry;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionResource.class})
public class FormInstanceNestedCollectionResource
implements NestedCollectionResource<DDMFormInstance, Long, FormInstanceIdentifier, Long, ContentSpaceIdentifier> {
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private EvaluateContextHelper _evaluateContextHelper;
    @Reference
    private FetchLatestRecordHelper _fetchLatestRecordVersionHelper;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private UploadFileHelper _uploadFileHelper;

    public NestedCollectionRoutes<DDMFormInstance, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<DDMFormInstance, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, Company.class).build();
    }

    public String getName() {
        return "form-instance";
    }

    public ItemRoutes<DDMFormInstance, Long> itemRoutes(ItemRoutes.Builder<DDMFormInstance, Long> builder) {
        return builder.addGetter(arg_0 -> ((DDMFormInstanceService)this._ddmFormInstanceService).getFormInstance(arg_0)).addCustomRoute((CustomRoute)new EvaluateContextRoute(), this::_evaluateContext, DDMFormRenderingContext.class, AcceptLanguage.class, FormContextIdentifier.class, this::_hasPermission, FormContextForm::buildForm).addCustomRoute((CustomRoute)new FetchLatestDraftRoute(), this::_fetchDDMFormInstanceRecord, CurrentUser.class, FormInstanceRecordIdentifier.class, this::_hasPermission, FetchLatestDraftForm::buildForm).addCustomRoute((CustomRoute)new UploadFileRoute(), this::_uploadFile, MediaObjectIdentifier.class, this::_hasPermission, MediaObjectCreatorForm::buildForm).build();
    }

    public Representor<DDMFormInstance> representor(Representor.Builder<DDMFormInstance, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("FormInstance", new String[0]).identifier(DDMFormInstanceModel::getFormInstanceId).addBidirectionalModel("contentSpace", "formInstances", ContentSpaceIdentifier.class, DDMFormInstanceModel::getGroupId).addDate("dateCreated", DDMFormInstanceModel::getCreateDate)).addDate("dateModified", DDMFormInstanceModel::getModifiedDate)).addDate("datePublished", DDMFormInstanceModel::getLastPublishDate)).addLinkedModel("creator", PersonIdentifier.class, DDMFormInstanceModel::getUserId)).addLinkedModel("structure", StructureIdentifier.class, DDMFormInstanceModel::getStructureId)).addNested("settings", FormInstanceRepresentorUtil::getSettings, FormInstanceNestedCollectionResource::_buildSettings)).addNested("version", FormInstanceRepresentorUtil::getVersion, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("FormInstanceVersion", new String[0]).addLinkedModel("creator", PersonIdentifier.class, DDMFormInstanceVersionModel::getUserId)).addString("name", DDMFormInstanceVersionModel::getVersion)).build())).addLocalizedStringByLocale("description", DDMFormInstanceModel::getDescription)).addLocalizedStringByLocale("name", DDMFormInstanceModel::getName)).addString("defaultLanguage", DDMFormInstanceModel::getDefaultLanguageId)).addStringList("availableLanguages", FormInstanceRepresentorUtil::getAvailableLanguages)).build();
    }

    private static NestedRepresentor<DDMFormInstanceSettings> _buildSettings(NestedRepresentor.Builder<DDMFormInstanceSettings> builder) {
        return (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)builder.types("FormInstanceSettings", new String[0]).addBoolean("isPublished", DDMFormInstanceSettings::published)).addBoolean("isRequireAuthentication", DDMFormInstanceSettings::requireAuthentication)).addBoolean("isRequireCaptcha", DDMFormInstanceSettings::requireCaptcha)).addNested("emailNotification", Function.identity(), emailSettingsBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)emailSettingsBuilder.types("EmailMessage", new String[0]).addBoolean("isEnabled", DDMFormInstanceSettings::sendEmailNotification)).addNested("sender", Function.identity(), senderBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)senderBuilder.types("ContactPoint", new String[0]).addString("email", DDMFormInstanceSettings::emailFromAddress)).addString("name", DDMFormInstanceSettings::emailFromName)).build())).addNested("toRecipient", Function.identity(), toRecipientBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)toRecipientBuilder.types("ContactPoint", new String[0]).addString("email", DDMFormInstanceSettings::emailToAddress)).build())).addString("about", DDMFormInstanceSettings::emailSubject)).build())).addString("redirectURL", DDMFormInstanceSettings::redirectURL)).addString("storageType", DDMFormInstanceSettings::storageType)).addString("workflowDefinition", DDMFormInstanceSettings::workflowDefinition)).build();
    }

    private FormContextWrapper _evaluateContext(Long ddmFormInstanceId, FormContextForm formContextForm, DDMFormRenderingContext ddmFormRenderingContext, AcceptLanguage language) {
        return (FormContextWrapper)Try.fromFallible(() -> this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId.longValue())).map(DDMFormInstance::getStructure).map(ddmStructure -> this._evaluateContextHelper.evaluateContext(formContextForm.getFieldValues(), (DDMStructure)ddmStructure, ddmFormRenderingContext, language.getPreferredLocale())).orElse(null);
    }

    private DDMFormInstanceRecord _fetchDDMFormInstanceRecord(Long ddmFormInstanceId, FetchLatestDraftForm fetchLatestDraftForm, CurrentUser currentUser) {
        return (DDMFormInstanceRecord)Try.fromFallible(() -> this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId.longValue())).map(ddmFormInstance -> this._fetchLatestRecordVersionHelper.fetchLatestDraftRecord((DDMFormInstance)ddmFormInstance, currentUser)).orElse(null);
    }

    private PageItems<DDMFormInstance> _getPageItems(Pagination pagination, long groupId, Company company) {
        List ddmFormInstances = this._ddmFormInstanceService.getFormInstances(company.getCompanyId(), groupId, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this._ddmFormInstanceService.getFormInstancesCount(company.getCompanyId(), groupId);
        return new PageItems((Collection)ddmFormInstances, count);
    }

    private Boolean _hasPermission(Credentials credentials, Long formInstanceId) {
        return (Boolean)Try.fromFallible(() -> (Boolean)this._hasPermission.forAddingIn(FormInstanceRecordIdentifier.class).apply((Object)credentials, (Object)formInstanceId)).orElse((Object)false);
    }

    private FileEntry _uploadFile(Long ddmFormInstanceId, MediaObjectCreatorForm mediaObjectCreatorForm) {
        return (FileEntry)Try.fromFallible(() -> this._ddmFormInstanceService.getFormInstance(ddmFormInstanceId.longValue())).map(ddmFormInstance -> this._uploadFileHelper.uploadFile((DDMFormInstance)ddmFormInstance, mediaObjectCreatorForm)).orElse(null);
    }
}

