Liferay.Loader.define("asset-taglib$lodash-es@4.17.11/_arrayEach", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  /**
   * A specialized version of `_.forEach` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns `array`.
   */
  function arrayEach(array, iteratee) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      if (iteratee(array[index], index, array) === false) {
        break;
      }
    }
    return array;
  }

  export default arrayEach;
});
//# sourceMappingURL=_arrayEach.js.map