/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.analytics.message.storage.model.impl;

import com.liferay.analytics.message.storage.model.AnalyticsMessage;
import com.liferay.analytics.message.storage.model.AnalyticsMessageBodyBlobModel;
import com.liferay.analytics.message.storage.model.AnalyticsMessageModel;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the AnalyticsMessage service. Represents a row in the &quot;AnalyticsMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AnalyticsMessageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AnalyticsMessageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AnalyticsMessageImpl
 * @generated
 */
public class AnalyticsMessageModelImpl
	extends BaseModelImpl<AnalyticsMessage> implements AnalyticsMessageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a analytics message model instance should use the <code>AnalyticsMessage</code> interface instead.
	 */
	public static final String TABLE_NAME = "AnalyticsMessage";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"analyticsMessageId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"body", Types.BLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("analyticsMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("body", Types.BLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table AnalyticsMessage (mvccVersion LONG default 0 not null,analyticsMessageId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,body BLOB)";

	public static final String TABLE_SQL_DROP = "drop table AnalyticsMessage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY analyticsMessage.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY AnalyticsMessage.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.analytics.message.storage.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.analytics.message.storage.model.AnalyticsMessage"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.analytics.message.storage.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.analytics.message.storage.model.AnalyticsMessage"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.analytics.message.storage.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.analytics.message.storage.model.AnalyticsMessage"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long CREATEDATE_COLUMN_BITMASK = 2L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.analytics.message.storage.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.analytics.message.storage.model.AnalyticsMessage"));

	public AnalyticsMessageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _analyticsMessageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setAnalyticsMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _analyticsMessageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return AnalyticsMessage.class;
	}

	@Override
	public String getModelClassName() {
		return AnalyticsMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<AnalyticsMessage, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<AnalyticsMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AnalyticsMessage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((AnalyticsMessage)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<AnalyticsMessage, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<AnalyticsMessage, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(AnalyticsMessage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<AnalyticsMessage, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<AnalyticsMessage, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, AnalyticsMessage>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			AnalyticsMessage.class.getClassLoader(), AnalyticsMessage.class,
			ModelWrapper.class);

		try {
			Constructor<AnalyticsMessage> constructor =
				(Constructor<AnalyticsMessage>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException roe) {
					throw new InternalError(roe);
				}
			};
		}
		catch (NoSuchMethodException nsme) {
			throw new InternalError(nsme);
		}
	}

	private static final Map<String, Function<AnalyticsMessage, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<AnalyticsMessage, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<AnalyticsMessage, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<AnalyticsMessage, Object>>();
		Map<String, BiConsumer<AnalyticsMessage, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<AnalyticsMessage, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getMvccVersion();
				}

			});
		attributeSetterBiConsumers.put(
			"mvccVersion",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage,
					Object mvccVersionObject) {

					analyticsMessage.setMvccVersion((Long)mvccVersionObject);
				}

			});
		attributeGetterFunctions.put(
			"analyticsMessageId",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getAnalyticsMessageId();
				}

			});
		attributeSetterBiConsumers.put(
			"analyticsMessageId",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage,
					Object analyticsMessageIdObject) {

					analyticsMessage.setAnalyticsMessageId(
						(Long)analyticsMessageIdObject);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage, Object companyIdObject) {

					analyticsMessage.setCompanyId((Long)companyIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage, Object userIdObject) {

					analyticsMessage.setUserId((Long)userIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage, Object userNameObject) {

					analyticsMessage.setUserName((String)userNameObject);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage,
					Object createDateObject) {

					analyticsMessage.setCreateDate((Date)createDateObject);
				}

			});
		attributeGetterFunctions.put(
			"body",
			new Function<AnalyticsMessage, Object>() {

				@Override
				public Object apply(AnalyticsMessage analyticsMessage) {
					return analyticsMessage.getBody();
				}

			});
		attributeSetterBiConsumers.put(
			"body",
			new BiConsumer<AnalyticsMessage, Object>() {

				@Override
				public void accept(
					AnalyticsMessage analyticsMessage, Object bodyObject) {

					analyticsMessage.setBody((Blob)bodyObject);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@Override
	public long getAnalyticsMessageId() {
		return _analyticsMessageId;
	}

	@Override
	public void setAnalyticsMessageId(long analyticsMessageId) {
		_analyticsMessageId = analyticsMessageId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@Override
	public Blob getBody() {
		if (_bodyBlobModel == null) {
			try {
				_bodyBlobModel =
					AnalyticsMessageLocalServiceUtil.getBodyBlobModel(
						getPrimaryKey());
			}
			catch (Exception e) {
			}
		}

		Blob blob = null;

		if (_bodyBlobModel != null) {
			blob = _bodyBlobModel.getBodyBlob();
		}

		return blob;
	}

	@Override
	public void setBody(Blob body) {
		if (_bodyBlobModel == null) {
			_bodyBlobModel = new AnalyticsMessageBodyBlobModel(
				getPrimaryKey(), body);
		}
		else {
			_bodyBlobModel.setBodyBlob(body);
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), AnalyticsMessage.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public AnalyticsMessage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, AnalyticsMessage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AnalyticsMessageImpl analyticsMessageImpl = new AnalyticsMessageImpl();

		analyticsMessageImpl.setMvccVersion(getMvccVersion());
		analyticsMessageImpl.setAnalyticsMessageId(getAnalyticsMessageId());
		analyticsMessageImpl.setCompanyId(getCompanyId());
		analyticsMessageImpl.setUserId(getUserId());
		analyticsMessageImpl.setUserName(getUserName());
		analyticsMessageImpl.setCreateDate(getCreateDate());

		analyticsMessageImpl.resetOriginalValues();

		return analyticsMessageImpl;
	}

	@Override
	public int compareTo(AnalyticsMessage analyticsMessage) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), analyticsMessage.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof AnalyticsMessage)) {
			return false;
		}

		AnalyticsMessage analyticsMessage = (AnalyticsMessage)obj;

		long primaryKey = analyticsMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		AnalyticsMessageModelImpl analyticsMessageModelImpl = this;

		analyticsMessageModelImpl._originalCompanyId =
			analyticsMessageModelImpl._companyId;

		analyticsMessageModelImpl._setOriginalCompanyId = false;

		analyticsMessageModelImpl._bodyBlobModel = null;

		analyticsMessageModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<AnalyticsMessage> toCacheModel() {
		AnalyticsMessageCacheModel analyticsMessageCacheModel =
			new AnalyticsMessageCacheModel();

		analyticsMessageCacheModel.mvccVersion = getMvccVersion();

		analyticsMessageCacheModel.analyticsMessageId = getAnalyticsMessageId();

		analyticsMessageCacheModel.companyId = getCompanyId();

		analyticsMessageCacheModel.userId = getUserId();

		analyticsMessageCacheModel.userName = getUserName();

		String userName = analyticsMessageCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			analyticsMessageCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			analyticsMessageCacheModel.createDate = createDate.getTime();
		}
		else {
			analyticsMessageCacheModel.createDate = Long.MIN_VALUE;
		}

		return analyticsMessageCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(15);

		sb.append("{mvccVersion=");
		sb.append(getMvccVersion());
		sb.append(", analyticsMessageId=");
		sb.append(getAnalyticsMessageId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(25);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.analytics.message.storage.model.AnalyticsMessage");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>mvccVersion</column-name><column-value><![CDATA[");
		sb.append(getMvccVersion());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>analyticsMessageId</column-name><column-value><![CDATA[");
		sb.append(getAnalyticsMessageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, AnalyticsMessage>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _analyticsMessageId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private AnalyticsMessageBodyBlobModel _bodyBlobModel;
	private long _columnBitmask;
	private AnalyticsMessage _escapedModel;

}