/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.alloy.mvc;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

/**
 * @author William Newbury
 */
public class MockAlloyControllerImpl
	extends BaseAlloyControllerImpl implements AlloyController {

	public MockAlloyControllerImpl(
		BaseAlloyControllerImpl baseAlloyControllerImpl) {

		company = baseAlloyControllerImpl.company;

		try {
			user = UserLocalServiceUtil.getDefaultUser(company.getCompanyId());

			themeDisplay = baseAlloyControllerImpl.themeDisplay;

			themeDisplay = (ThemeDisplay)themeDisplay.clone();
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void afterPropertiesSet() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void execute() throws Exception {
		throw new UnsupportedOperationException();
	}

	@Override
	public Portlet getPortlet() {
		throw new UnsupportedOperationException();
	}

	@Override
	public HttpServletRequest getRequest() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String getResponseContent() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void setPageContext(PageContext pageContext) {
		throw new UnsupportedOperationException();
	}

	@Override
	public String translate(String pattern, Object... arguments) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void updateModel(BaseModel<?> baseModel, Object... properties)
		throws Exception {

		throw new UnsupportedOperationException();
	}

	@Override
	protected void setAttachedModel(BaseModel<?> baseModel) throws Exception {
	}

}