/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.alloy.mvc;

/**
 * @author Brian Wing Shun Chan
 */
public class AlloyException extends Exception {

	public AlloyException() {
	}

	public AlloyException(String msg) {
		super(msg);
	}

	public AlloyException(String msg, boolean log) {
		super(msg);

		this.log = log;
	}

	public AlloyException(String msg, Object[] arguments) {
		super(msg);

		this.arguments = arguments;
	}

	public AlloyException(String msg, Object[] arguments, boolean log) {
		super(msg);

		this.arguments = arguments;
		this.log = log;
	}

	public AlloyException(
		String msg, Object[] arguments, boolean log, Throwable cause) {

		super(msg, cause);

		this.arguments = arguments;
		this.log = log;
	}

	public AlloyException(String msg, Throwable cause) {
		super(msg, cause);
	}

	public AlloyException(Throwable cause) {
		super(cause);
	}

	protected Object[] arguments;
	protected boolean log = true;

}