/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.alloy.mvc;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

/**
 * @author Brian Wing Shun Chan
 */
public interface AlloyController {

	public void afterPropertiesSet();

	public void execute() throws Exception;

	public Portlet getPortlet();

	public HttpServletRequest getRequest();

	public String getResponseContent();

	public ThemeDisplay getThemeDisplay();

	public long increment() throws Exception;

	public void indexModel(BaseModel<?> baseModel) throws Exception;

	public void persistModel(BaseModel<?> baseModel) throws Exception;

	public void setModel(BaseModel<?> baseModel, Object... properties)
		throws Exception;

	public void setPageContext(PageContext pageContext);

	public void setUser(User user);

	public String translate(String pattern, Object... arguments);

	public void updateModel(BaseModel<?> baseModel, Object... properties)
		throws Exception;

	public void updateModelIgnoreRequest(
			BaseModel<?> baseModel, Object... properties)
		throws Exception;

}