/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.gif;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.Charsets;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.ErrorDirectory;
import com.drew.metadata.Metadata;
import com.drew.metadata.StringValue;
import com.drew.metadata.gif.GifAnimationDirectory;
import com.drew.metadata.gif.GifCommentDirectory;
import com.drew.metadata.gif.GifControlDirectory;
import com.drew.metadata.gif.GifHeaderDirectory;
import com.drew.metadata.gif.GifImageDirectory;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GifReader {
    private static final String GIF_87A_VERSION_IDENTIFIER = "87a";
    private static final String GIF_89A_VERSION_IDENTIFIER = "89a";

    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        GifHeaderDirectory header;
        reader.setMotorolaByteOrder(false);
        try {
            header = GifReader.readGifHeader(reader);
            metadata.addDirectory(header);
        }
        catch (IOException ex) {
            metadata.addDirectory(new ErrorDirectory("IOException processing GIF data"));
            return;
        }
        if (header.hasErrors()) {
            return;
        }
        try {
            Integer globalColorTableSize = header.getInteger(4);
            if (globalColorTableSize != null) {
                reader.skip(3 * globalColorTableSize);
            }
            block11: while (true) {
                byte marker;
                try {
                    marker = reader.getInt8();
                }
                catch (IOException ex) {
                    return;
                }
                switch (marker) {
                    case 33: {
                        GifReader.readGifExtensionBlock(reader, metadata);
                        continue block11;
                    }
                    case 44: {
                        metadata.addDirectory(GifReader.readImageBlock(reader));
                        GifReader.skipBlocks(reader);
                        continue block11;
                    }
                    case 59: {
                        return;
                    }
                }
                break;
            }
            return;
        }
        catch (IOException e) {
            metadata.addDirectory(new ErrorDirectory("IOException processing GIF data"));
            return;
        }
    }

    private static GifHeaderDirectory readGifHeader(@NotNull SequentialReader reader) throws IOException {
        GifHeaderDirectory headerDirectory = new GifHeaderDirectory();
        String signature = reader.getString(3);
        if (!signature.equals("GIF")) {
            headerDirectory.addError("Invalid GIF file signature");
            return headerDirectory;
        }
        String version = reader.getString(3);
        if (!version.equals(GIF_87A_VERSION_IDENTIFIER) && !version.equals(GIF_89A_VERSION_IDENTIFIER)) {
            headerDirectory.addError("Unexpected GIF version");
            return headerDirectory;
        }
        headerDirectory.setString(1, version);
        headerDirectory.setInt(2, reader.getUInt16());
        headerDirectory.setInt(3, reader.getUInt16());
        short flags = reader.getUInt8();
        int colorTableSize = 1 << (flags & 7) + 1;
        int bitsPerPixel = ((flags & 0x70) >> 4) + 1;
        boolean hasGlobalColorTable = (flags & 0xF) != 0;
        headerDirectory.setInt(4, colorTableSize);
        if (version.equals(GIF_89A_VERSION_IDENTIFIER)) {
            boolean isColorTableSorted = (flags & 8) != 0;
            headerDirectory.setBoolean(5, isColorTableSorted);
        }
        headerDirectory.setInt(6, bitsPerPixel);
        headerDirectory.setBoolean(7, hasGlobalColorTable);
        headerDirectory.setInt(8, reader.getUInt8());
        short aspectRatioByte = reader.getUInt8();
        if (aspectRatioByte != 0) {
            float pixelAspectRatio = (float)(((double)aspectRatioByte + 15.0) / 64.0);
            headerDirectory.setFloat(9, pixelAspectRatio);
        }
        return headerDirectory;
    }

    private static void readGifExtensionBlock(SequentialReader reader, Metadata metadata) throws IOException {
        long skipCount;
        byte extensionLabel = reader.getInt8();
        short blockSizeBytes = reader.getUInt8();
        long blockStartPos = reader.getPosition();
        switch (extensionLabel) {
            case 1: {
                Directory plainTextBlock = GifReader.readPlainTextBlock(reader, blockSizeBytes);
                if (plainTextBlock == null) break;
                metadata.addDirectory(plainTextBlock);
                break;
            }
            case -7: {
                metadata.addDirectory(GifReader.readControlBlock(reader, blockSizeBytes));
                break;
            }
            case -2: {
                metadata.addDirectory(GifReader.readCommentBlock(reader, blockSizeBytes));
                break;
            }
            case -1: {
                GifReader.readApplicationExtensionBlock(reader, blockSizeBytes, metadata);
                break;
            }
            default: {
                metadata.addDirectory(new ErrorDirectory(String.format("Unsupported GIF extension block with type 0x%02X.", extensionLabel)));
            }
        }
        if ((skipCount = blockStartPos + (long)blockSizeBytes - reader.getPosition()) > 0L) {
            reader.skip(skipCount);
        }
    }

    @Nullable
    private static Directory readPlainTextBlock(SequentialReader reader, int blockSizeBytes) throws IOException {
        if (blockSizeBytes != 12) {
            return new ErrorDirectory(String.format("Invalid GIF plain text block size. Expected 12, got %d.", blockSizeBytes));
        }
        reader.skip(12L);
        GifReader.skipBlocks(reader);
        return null;
    }

    private static GifCommentDirectory readCommentBlock(SequentialReader reader, int blockSizeBytes) throws IOException {
        byte[] buffer = GifReader.gatherBytes(reader, blockSizeBytes);
        return new GifCommentDirectory(new StringValue(buffer, Charsets.ASCII));
    }

    private static void readApplicationExtensionBlock(SequentialReader reader, int blockSizeBytes, Metadata metadata) throws IOException {
        if (blockSizeBytes != 11) {
            metadata.addDirectory(new ErrorDirectory(String.format("Invalid GIF application extension block size. Expected 11, got %d.", blockSizeBytes)));
            return;
        }
        String extensionType = reader.getString(blockSizeBytes, Charsets.UTF_8);
        if (extensionType.equals("XMP DataXMP")) {
            byte[] xmpBytes = GifReader.gatherBytes(reader);
            new XmpReader().extract(xmpBytes, 0, xmpBytes.length - 257, metadata, null);
        } else if (extensionType.equals("ICCRGBG1012")) {
            byte[] iccBytes = GifReader.gatherBytes(reader, reader.getByte());
            if (iccBytes.length != 0) {
                new IccReader().extract(new ByteArrayReader(iccBytes), metadata);
            }
        } else if (extensionType.equals("NETSCAPE2.0")) {
            reader.skip(2L);
            int iterationCount = reader.getUInt16();
            reader.skip(1L);
            GifAnimationDirectory animationDirectory = new GifAnimationDirectory();
            animationDirectory.setInt(1, iterationCount);
            metadata.addDirectory(animationDirectory);
        } else {
            GifReader.skipBlocks(reader);
        }
    }

    private static GifControlDirectory readControlBlock(SequentialReader reader, int blockSizeBytes) throws IOException {
        if (blockSizeBytes < 4) {
            blockSizeBytes = 4;
        }
        GifControlDirectory directory = new GifControlDirectory();
        reader.skip(1L);
        directory.setInt(1, reader.getUInt16());
        if (blockSizeBytes > 3) {
            reader.skip(blockSizeBytes - 3);
        }
        reader.getByte();
        return directory;
    }

    private static GifImageDirectory readImageBlock(SequentialReader reader) throws IOException {
        GifImageDirectory imageDirectory = new GifImageDirectory();
        imageDirectory.setInt(1, reader.getUInt16());
        imageDirectory.setInt(2, reader.getUInt16());
        imageDirectory.setInt(3, reader.getUInt16());
        imageDirectory.setInt(4, reader.getUInt16());
        byte flags = reader.getByte();
        boolean hasColorTable = (flags & 7) != 0;
        boolean isInterlaced = (flags & 0x40) != 0;
        boolean isColorTableSorted = (flags & 0x20) != 0;
        imageDirectory.setBoolean(5, hasColorTable);
        imageDirectory.setBoolean(6, isInterlaced);
        if (hasColorTable) {
            imageDirectory.setBoolean(7, isColorTableSorted);
            int bitsPerPixel = (flags & 7) + 1;
            imageDirectory.setInt(8, bitsPerPixel);
            reader.skip(3 * (2 << (flags & 7)));
        }
        reader.getByte();
        return imageDirectory;
    }

    private static byte[] gatherBytes(SequentialReader reader) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[257];
        byte b;
        while ((b = reader.getByte()) != 0) {
            int bInt = b & 0xFF;
            buffer[0] = b;
            reader.getBytes(buffer, 1, bInt);
            bytes.write(buffer, 0, bInt + 1);
        }
        return bytes.toByteArray();
    }

    private static byte[] gatherBytes(SequentialReader reader, int firstLength) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int length = firstLength;
        while (length > 0) {
            buffer.write(reader.getBytes(length), 0, length);
            length = reader.getByte();
        }
        return buffer.toByteArray();
    }

    private static void skipBlocks(SequentialReader reader) throws IOException {
        short length;
        while ((length = reader.getUInt8()) != 0) {
            reader.skip(length);
        }
        return;
    }
}

