/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        Message messageMessage;
        Destination destinationDestination;
        if (sendEmailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        if (sendEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendEmailRequest.getSource()));
        }
        if ((destinationDestination = sendEmailRequest.getDestination()) != null) {
            List<String> toAddressesList = destinationDestination.getToAddresses();
            int toAddressesListIndex = 1;
            for (String toAddressesListValue : toAddressesList) {
                if (toAddressesListValue != null) {
                    request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString((String)toAddressesListValue));
                }
                ++toAddressesListIndex;
            }
            List<String> ccAddressesList = destinationDestination.getCcAddresses();
            int ccAddressesListIndex = 1;
            for (String ccAddressesListValue : ccAddressesList) {
                if (ccAddressesListValue != null) {
                    request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString((String)ccAddressesListValue));
                }
                ++ccAddressesListIndex;
            }
            List<String> bccAddressesList = destinationDestination.getBccAddresses();
            int bccAddressesListIndex = 1;
            for (String bccAddressesListValue : bccAddressesList) {
                if (bccAddressesListValue != null) {
                    request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString((String)bccAddressesListValue));
                }
                ++bccAddressesListIndex;
            }
        }
        if ((messageMessage = sendEmailRequest.getMessage()) != null) {
            Body bodyBody;
            Content contentSubject = messageMessage.getSubject();
            if (contentSubject != null) {
                if (contentSubject.getData() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString((String)contentSubject.getData()));
                }
                if (contentSubject.getCharset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString((String)contentSubject.getCharset()));
                }
            }
            if ((bodyBody = messageMessage.getBody()) != null) {
                Content contentHtml;
                Content contentText = bodyBody.getText();
                if (contentText != null) {
                    if (contentText.getData() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString((String)contentText.getData()));
                    }
                    if (contentText.getCharset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString((String)contentText.getCharset()));
                    }
                }
                if ((contentHtml = bodyBody.getHtml()) != null) {
                    if (contentHtml.getData() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString((String)contentHtml.getData()));
                    }
                    if (contentHtml.getCharset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString((String)contentHtml.getCharset()));
                    }
                }
            }
        }
        List<String> replyToAddressesList = sendEmailRequest.getReplyToAddresses();
        int replyToAddressesListIndex = 1;
        for (String replyToAddressesListValue : replyToAddressesList) {
            if (replyToAddressesListValue != null) {
                request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString((String)replyToAddressesListValue));
            }
            ++replyToAddressesListIndex;
        }
        if (sendEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString((String)sendEmailRequest.getReturnPath()));
        }
        if (sendEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendEmailRequest.getSourceArn()));
        }
        if (sendEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendEmailRequest.getReturnPathArn()));
        }
        return request;
    }
}

