/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rdsdata.model.Value;
import java.nio.ByteBuffer;
import java.util.List;

@SdkInternalApi
public class ValueMarshaller {
    private static final MarshallingInfo<List> ARRAYVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arrayValues").build();
    private static final MarshallingInfo<Long> BIGINTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bigIntValue").build();
    private static final MarshallingInfo<Boolean> BITVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitValue").build();
    private static final MarshallingInfo<ByteBuffer> BLOBVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blobValue").build();
    private static final MarshallingInfo<Double> DOUBLEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("doubleValue").build();
    private static final MarshallingInfo<Integer> INTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intValue").build();
    private static final MarshallingInfo<Boolean> ISNULL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isNull").build();
    private static final MarshallingInfo<Float> REALVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("realValue").build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValue").build();
    private static final MarshallingInfo<StructuredPojo> STRUCTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("structValue").build();
    private static final ValueMarshaller instance = new ValueMarshaller();

    public static ValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(Value value, ProtocolMarshaller protocolMarshaller) {
        if (value == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(value.getArrayValues(), ARRAYVALUES_BINDING);
            protocolMarshaller.marshall((Object)value.getBigIntValue(), BIGINTVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getBitValue(), BITVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getBlobValue(), BLOBVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getDoubleValue(), DOUBLEVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getIntValue(), INTVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getIsNull(), ISNULL_BINDING);
            protocolMarshaller.marshall((Object)value.getRealValue(), REALVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getStringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall((Object)value.getStructValue(), STRUCTVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

