package cn.zoecloud.core.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 日志工具
 * @author leo
 */
public class LogUtil {
    private static final String LOGGER_PACKAGE_NAME = "cn.zoecloud.core";
    private static final Log log = LogFactory.getLog(LOGGER_PACKAGE_NAME);

    public LogUtil() {
    }

    public static Log getLog() {
        return log;
    }

    public static <ExType> void logException(String messagePrefix, ExType ex) {
        assert ex instanceof Exception;

        String detailMessage = messagePrefix + ((Exception)ex).getMessage();
        log.warn(detailMessage);
    }
}
