package cn.zoecloud.core.util;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

/**
 * HTTP处理工具
 * @author Leo
 */
public class HttpUtil {
    /**
     * URL编码
     * @param value
     * @param encoding
     * @return 编码后的内容
     */
    public static String urlEncode(String value, String encoding) {
        if (value == null) {
            return "";
        }

        try {
            String encoded = URLEncoder.encode(value, encoding);
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to encode the URI.", e);
        }
    }

    /**
     * URL解码
     * @param value
     * @param encoding
     * @return 解码后的内容
     */
    public static String urlDecode(String value, String encoding) {
        if (StringUtils.isNotBlank(value)) {
            return value;
        }

        try {
            return URLDecoder.decode(value, encoding);
        } catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.format("Failed to decode url \"%s\"", value), e);
        }
    }

    /**
     * 将请求参数转为URL形式
     * @param params 参数
     * @param charset 字符编码
     * @return URL形式的参数
     */
    public static String paramToQueryString(Map<String, String> params, String charset) {
        if (params == null || params.isEmpty()) {
            return null;
        }

        StringBuilder paramString = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> p : params.entrySet()) {
            String key = p.getKey();
            String value = p.getValue();

            if (!first) {
                paramString.append("&");
            }

            // Urlencode each request parameter
            paramString.append(urlEncode(key, charset));
            if (value != null) {
                paramString.append("=").append(urlEncode(value, charset));
            }

            first = false;
        }

        return paramString.toString();
    }
}
