package cn.zoecloud.core.service;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.internal.ZoeCloudConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.*;
import org.apache.http.entity.StringEntity;

import java.util.Map;

/**
 * HTTP请求工厂
 * @author Leo
 */
public class HttpRequestFactory {
    /**
     * 根据请求消息产生一个HttpClient请求对象
     * @param request
     * @return
     */
    public HttpRequestBase createHttpRequest(RequestMessage request) {
        String url = request.getUrl();

        HttpRequestBase httpRequest;
        HttpMethod method = request.getMethod();

        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(url);

            if (StringUtils.isNotBlank(request.getBody())) {
                postMethod.setEntity(new StringEntity(request.getBody(), ZoeCloudConstants.DEFAULT_CHARSET_NAME));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(url);

            if (StringUtils.isNotBlank(request.getBody())) {
                putMethod.setEntity(new StringEntity(request.getBody(), ZoeCloudConstants.DEFAULT_CHARSET_NAME));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(url);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(url);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(url);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(url);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }

        configureRequestHeaders(request, httpRequest);

        return httpRequest;
    }

    private void configureRequestHeaders(RequestMessage request, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase(HttpHeaders.CONTENT_LENGTH)
                    || entry.getKey().equalsIgnoreCase(HttpHeaders.HOST)) {
                continue;
            }

            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }
}
