package cn.zoecloud.core.operation;

import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.model.GetGroupPageRequest;
import cn.zoecloud.core.model.GetGroupPageResult;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.service.ServiceClient;

import static cn.zoecloud.core.internal.ZoeCloudResponseParsers.getGroupPageResponseParser;

/**
 * 分组的操作
 * @author Leo
 */
public class ZoeCloudGroupOperation extends ZoeCloudOperation {
    private static final String GROUP_PATH = "/api/2.0/groups";

    public ZoeCloudGroupOperation(ServiceClient client, Credential credential, String endpoint) {
        super(client, credential, endpoint);
    }

    /**
     * 分页获取分组信息
     * @param getGroupPageRequest
     * @return
     * @throws ServiceException
     * @throws ClientException
     */
    public GetGroupPageResult getGroupPage(GetGroupPageRequest getGroupPageRequest) throws ServiceException, ClientException {
        assert(getGroupPageRequest != null);
        String url = String.format("%s?page=%d&size=%d", GROUP_PATH,
                getGroupPageRequest.getPageRequest().getPageNumber(),
                getGroupPageRequest.getPageRequest().getPageSize());
        RequestMessage request = new RequestMessage(this.getEndpoint(), url);
        return doOperation(request, getGroupPageResponseParser);
    }
}
