package cn.zoecloud.core.model.comm;

import cn.zoecloud.core.internal.ZoeCloudConstants;

/**
 * 分页信息
 * @author Leo
 */
public class PageRequest {
    private int pageNumber;
    private int pageSize;
    private String sortField;
    private Order order;

    /**
     * 默认第1页，每页20条记录
     */
    public PageRequest() {
        this(ZoeCloudConstants.DEFAULT_PAGE_NUMBER, ZoeCloudConstants.DEFAULT_PAGE_SIZE);
    }

    /**
     * 页码0为第1页，每页默认20条记录
     * @param pageNumber
     */
    public PageRequest(int pageNumber) {
        this(pageNumber, ZoeCloudConstants.DEFAULT_PAGE_SIZE);
    }

    public PageRequest(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public PageRequest(String sortField) {
        this(sortField, Order.ASC);
    }

    public PageRequest(String sortField, Order order) {
        this();
        this.sortField = sortField;
        this.order = order;
    }

    public PageRequest(int pageNumber, int pageSize, String sortField, Order order) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.sortField = sortField;
        this.order = order;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }
}
