package cn.zoecloud.core.model.comm;

import java.util.List;

/**
 * 包含分页信息的结果
 * @author Leo
 */
public class GenericPageResult<T> {
    private List<T> entities;
    private long totalElements;
    private int pageNumber;
    private int pageSize;

    public GenericPageResult() {}
    public GenericPageResult(GenericPageResult genericPageResult) {
        this.entities = genericPageResult.getEntities();
        this.totalElements = genericPageResult.getTotalElements();
        this.pageNumber = genericPageResult.getPageNumber();
        this.pageSize = genericPageResult.getPageSize();
    }

    public List<T> getEntities() {
        return entities;
    }

    public void setEntities(List<T> entities) {
        this.entities = entities;
    }

    public long getTotalElements() {
        return totalElements;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public int getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
