package cn.zoecloud.core.model;

/**
 * 播放模式
 * @author Leo
 */
public enum PlayMode {
    TIMING(2), COUNT(3), DURATION(4), END(5);

    private int code;

    PlayMode(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static PlayMode findOne(Integer code) {
        if (code == null) {
            return null;
        }

        if (code == TIMING.code) {
            return TIMING;
        } else if (code == COUNT.code) {
            return COUNT;
        } else if (code == DURATION.code) {
            return DURATION;
        } else if (code == END.code) {
            return END;
        }
        return null;
    }
}
