package cn.zoecloud.core.model;

import cn.zoecloud.core.model.comm.GenericPageRequest;
import cn.zoecloud.core.model.comm.PageRequest;

import java.util.List;

/**
 * 分页获取设备信息的请求，支持数据筛选
 *
 * @author Leo
 */
public class GetTerminalPageRequest extends GenericPageRequest {
    private Filter filter;

    public GetTerminalPageRequest() {
        super();
    }

    public GetTerminalPageRequest(PageRequest pageRequest) {
        super(pageRequest);
    }

    public GetTerminalPageRequest(Filter filter) {
        super();
        this.filter = filter;
    }

    public GetTerminalPageRequest(PageRequest pageRequest, Filter filter) {
        super(pageRequest);
        this.filter = filter;
    }

    public Filter getFilter() {
        return filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public enum SortField {
        TERMINAL_NAME("terminalName");

        private String fieldName;

        SortField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public static class Filter {
        private Boolean online;
        private List<String> groupIds;
        private String keyword;

        public Boolean getOnline() {
            return online;
        }

        public void setOnline(Boolean online) {
            this.online = online;
        }

        public List<String> getGroupIds() {
            return groupIds;
        }

        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        public String getKeyword() {
            return keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }
    }
}
