package cn.zoecloud.core.model;

import java.util.List;

/**
 * 基本的命令结果
 * @author leo
 */
public class CommandResult {
    private String commandId;
    private String terminalId;
    private String terminalCode;
    private String terminalName;
    private Command command;
    private String description;
    private CommandStatus status;

    public String getCommandId() {
        return commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    public Command getCommand() {
        return command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CommandStatus getStatus() {
        return status;
    }

    public void setStatus(CommandStatus status) {
        this.status = status;
    }

    public static class NoneExtra extends CommandResult {
    }

    public static class StringExtra extends CommandResult {
        private String extras;

        public String getExtras() {
            return extras;
        }

        public void setExtras(String extras) {
            this.extras = extras;
        }
    }

    public static class ProgramExtra extends CommandResult {
        private List<ProgramInfo> extras;

        public List<ProgramInfo> getExtras() {
            return extras;
        }

        public void setExtras(List<ProgramInfo> extras) {
            this.extras = extras;
        }
    }
}
