/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.util;

import com.sprite.framework.entity.Delegator;
import com.sprite.framework.entity.EntityCondition;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.script.EntityView;
import com.sprite.framework.entity.transaction.TransactionExecutor;
import com.sprite.framework.entity.transaction.TransactionScript;
import com.sprite.utils.UtilCollection;
import java.util.concurrent.atomic.AtomicLong;

public final class SequenceUtil {
    private EntityScriptExecutor scriptExecutor;
    private Delegator delegator;
    private String sequenceName;
    private final AtomicLong sequenceValue = new AtomicLong(0L);
    private final AtomicLong storedSequenceValue = new AtomicLong(0L);
    private final long bankSize;
    private final long beginValue;

    public SequenceUtil(String sequenceName, long beginValue, long bankSize, EntityScriptExecutor scriptExecutor, Delegator delegator) {
        this.sequenceName = sequenceName;
        this.scriptExecutor = scriptExecutor;
        this.bankSize = bankSize;
        this.beginValue = beginValue;
        this.delegator = delegator;
    }

    private void store() {
        TransactionScript transactionScript = this.scriptExecutor.beginTransaction(true);
        transactionScript.execute(new TransactionExecutor(){

            @Override
            public void execute() {
                EntityView script = new EntityView("SequenceItem", "a");
                script.addViewField("a", "sequenceId");
                script.addViewField("a", "sequenceValue");
                script.setWhereCondition(EntityCondition.equal("sequenceId", SequenceUtil.this.sequenceName));
                SequenceItem item = (SequenceItem)UtilCollection.at(SequenceUtil.this.scriptExecutor.query(script, SequenceItem.class), (int)0);
                if (item == null) {
                    item = new SequenceItem();
                    item.setSequenceId(SequenceUtil.this.sequenceName);
                    SequenceUtil.this.sequenceValue.addAndGet(SequenceUtil.this.beginValue);
                    SequenceUtil.this.storedSequenceValue.addAndGet(SequenceUtil.this.beginValue);
                } else {
                    SequenceUtil.this.sequenceValue.set(item.getSequenceValue());
                    SequenceUtil.this.storedSequenceValue.set(item.getSequenceValue());
                    SequenceUtil.this.storedSequenceValue.addAndGet(SequenceUtil.this.bankSize);
                    item.setSequenceValue(SequenceUtil.this.storedSequenceValue.get());
                }
                SequenceUtil.this.delegator.store("SequenceItem", item);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextValue() {
        if (this.sequenceValue.get() >= this.storedSequenceValue.get()) {
            SequenceUtil sequenceUtil = this;
            synchronized (sequenceUtil) {
                if (this.sequenceValue.get() >= this.storedSequenceValue.get()) {
                    this.store();
                }
            }
        }
        return this.sequenceValue.addAndGet(1L);
    }

    public static class SequenceItem {
        private String sequenceId;
        private long sequenceValue = 1000L;

        public String getSequenceId() {
            return this.sequenceId;
        }

        public void setSequenceId(String sequenceId) {
            this.sequenceId = sequenceId;
        }

        public long getSequenceValue() {
            return this.sequenceValue;
        }

        public void setSequenceValue(long sequenceValue) {
            this.sequenceValue = sequenceValue;
        }
    }
}

