/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.script;

import com.sprite.framework.entity.DataScriptStatement;
import com.sprite.framework.entity.EntityCondition;
import com.sprite.framework.entity.EntityException;
import com.sprite.framework.entity.EntityScript;
import com.sprite.framework.entity.model.ModelEntity;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.model.ModelEntityView;
import com.sprite.utils.UtilString;
import java.util.HashMap;
import java.util.Map;

public final class EntityUpdateScript
implements EntityScript {
    private String entityName;
    private Map<String, Object> fieldsToUpdate = new HashMap<String, Object>();
    private EntityCondition whereCondition;

    public EntityUpdateScript(String entityName) {
        this.entityName = entityName;
    }

    protected EntityUpdateScript() {
    }

    public void setWhereCondition(EntityCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public void makeStatement(DataScriptStatement statement, ModelEntityView modelViewEntity) throws EntityException {
        this.initModelViewEntity(modelViewEntity);
        ModelEntity modelEntity = ModelEntityUtil.getModelEntity(this.entityName);
        statement.append(UtilString.place((String)"UPDATE {} SET ", (Object[])new Object[]{modelEntity.getTableName()}));
        int lg = this.fieldsToUpdate.size();
        for (Map.Entry<String, Object> entry : this.fieldsToUpdate.entrySet()) {
            statement.append(modelEntity.getModelField(entry.getKey()).getColName()).append("=?");
            statement.addParam(entry.getValue());
            if (lg > 1) {
                statement.append(",");
            }
            --lg;
        }
        statement.append(" WHERE ");
        this.whereCondition.makeScript(statement, modelEntity);
    }

    public void addFields(Map<String, Object> fields) {
        this.fieldsToUpdate.putAll(fields);
    }

    private void initModelViewEntity(ModelEntityView modelViewEntity) throws EntityException {
        if (modelViewEntity == null) {
            return;
        }
    }

    @Override
    public DataScriptStatement getStatement() {
        DataScriptStatement statement = new DataScriptStatement();
        this.makeStatement(statement, null);
        return statement;
    }
}

