/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity.config;

import com.sprite.framework.config.ResourceInfo;
import com.sprite.utils.UtilXml;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class EntityResourceInfo
extends ResourceInfo {
    private static final List<EntityResourceInfo> entityDatas = new LinkedList<EntityResourceInfo>();
    private static final List<EntityResourceInfo> entityModels = new LinkedList<EntityResourceInfo>();
    private static final Map<String, EntityResourceInfo> fieldTypeDef = new HashMap<String, EntityResourceInfo>();
    private String resourceType;
    private String name;

    public static void addEntityData(EntityResourceInfo resourceInfo) {
        entityDatas.add(resourceInfo);
    }

    public static void addEntityModel(EntityResourceInfo resourceInfo) {
        entityModels.add(resourceInfo);
    }

    public static void addFieldType(EntityResourceInfo entityResourceInfo) {
        fieldTypeDef.put(entityResourceInfo.getName(), entityResourceInfo);
    }

    public static EntityResourceInfo getFieldType(String sqlType) {
        return fieldTypeDef.get(sqlType);
    }

    public static List<EntityResourceInfo> getEntityDatas() {
        return entityDatas;
    }

    public static List<EntityResourceInfo> getEntityModels() {
        return entityModels;
    }

    public EntityResourceInfo(String location, String resourceType) {
        this.location = location;
        this.resourceType = resourceType;
    }

    public Document getDocument() throws Exception {
        return UtilXml.readXmlDocument((InputStream)this.getStream(), (boolean)false, null);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

