/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.framework.entity;

import com.sprite.framework.common.Assert;
import com.sprite.framework.entity.EntityObject;
import com.sprite.framework.entity.EntityScriptExecutor;
import com.sprite.framework.entity.config.EntityResourceInfo;
import com.sprite.framework.entity.model.EntityModelReader;
import com.sprite.framework.entity.model.ModelEntityUtil;
import com.sprite.framework.entity.script.EntityInsertScript;
import com.sprite.framework.entity.transaction.TransactionExecutor;
import com.sprite.framework.entity.transaction.TransactionScript;
import com.sprite.framework.entity.util.EntityDataReader;
import com.sprite.framework.entity.util.EntityGroup;
import com.sprite.utils.UtilCollection;
import com.sprite.utils.UtilString;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLoader {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EntityScriptExecutor entityScriptExecutor;
    private String sqlType;

    public void load() {
        this.loadEntityModel(true);
        this.loadEntityData();
    }

    public void loadEntityModel(boolean updateDb) {
        Assert.notNull((Object)this.sqlType, (String)"sqlType is not assign");
        Assert.notNull((Object)this.entityScriptExecutor, (String)"entityScriptExecutor is not assign");
        try {
            EntityModelReader entityModelReader = new EntityModelReader();
            for (EntityResourceInfo resource : EntityResourceInfo.getEntityModels()) {
                entityModelReader.buildModel(resource.getDocument());
            }
            entityModelReader.merge();
            if (UtilString.isBlank((CharSequence)this.sqlType)) {
                throw new Exception("not specified sql type ");
            }
            EntityResourceInfo resourceInfo = EntityResourceInfo.getFieldType(this.sqlType);
            if (resourceInfo == null) {
                throw new Exception("not found fieldTypeDef \uff1a " + this.sqlType);
            }
            entityModelReader.buildModelFieldType(resourceInfo.getDocument(), this.sqlType);
            if (updateDb) {
                this.entityScriptExecutor.getDatabaseUtil().checkDb(ModelEntityUtil.getModelEntityList());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadEntityData() {
        Assert.notNull((Object)this.sqlType, (String)"sqlType is not assign");
        Assert.notNull((Object)this.entityScriptExecutor, (String)"entityScriptExecutor is not assign");
        try {
            LinkedList entityGroupList = new LinkedList();
            EntityDataReader dataReader = new EntityDataReader();
            for (EntityResourceInfo resource : EntityResourceInfo.getEntityDatas()) {
                dataReader.loadToEntity(resource.getDocument());
            }
            if (UtilCollection.isEmpty(entityGroupList)) {
                return;
            }
            for (final EntityGroup entityGroup : entityGroupList) {
                try {
                    TransactionScript transactionScript = this.entityScriptExecutor.beginTransaction(true);
                    transactionScript.execute(new TransactionExecutor(){

                        @Override
                        public void execute() {
                            for (EntityObject entityObject : entityGroup.getEntities()) {
                                EntityInsertScript insertScript = new EntityInsertScript(entityObject.getEntityName());
                                insertScript.addFields(entityObject);
                                EntityLoader.this.entityScriptExecutor.execute(insertScript);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.logger.warn("[loader] load entity data error, ", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public EntityScriptExecutor getEntityScriptExecutor() {
        return this.entityScriptExecutor;
    }

    public void setEntityScriptExecutor(EntityScriptExecutor entityScriptExecutor) {
        this.entityScriptExecutor = entityScriptExecutor;
    }
}

