/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.web.upload;

import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.util.Bytes;
import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.web.upload.WebForm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WebUpload {
    protected InputStream m_Input;
    protected byte[] m_Boundary;
    protected Map<String, WebForm> m_FormsMap;
    protected WebForm[] m_Forms;
    protected BytesOutputStream m_TempBuffer;

    protected abstract WebForm onFetchForm(InputStream var1, List<WebForm.Header> var2) throws IOException;

    public final WebForm get(int index) {
        if (this.m_Forms == null) {
            Collection<WebForm> c = this.m_FormsMap.values();
            this.m_Forms = c.toArray(new WebForm[c.size()]);
        }
        return this.m_Forms[index];
    }

    public final WebForm get(String name) {
        return this.m_FormsMap.get(name);
    }

    public final WebForm getForm(String name) {
        return this.get(name);
    }

    public final WebForm getForm(int index) {
        return this.get(index);
    }

    public final int size() {
        return this.m_FormsMap.size();
    }

    public final Map<String, WebForm> getForms() {
        return this.m_FormsMap;
    }

    public void input(InputStream in) throws IOException {
        List<WebForm.Header> headers;
        if (in == null) {
            throw new IOException("Invalid format MIME part(InputStream is null)!");
        }
        this.m_Input = in;
        this.m_FormsMap = new HashMap<String, WebForm>();
        this.readBoundary();
        WebForm form = null;
        PartInputStream uin = null;
        while ((headers = this.analyzeHeaders()).size() != 0) {
            uin = new PartInputStream();
            form = this.onFetchForm(uin, headers);
            if (form != null) {
                this.m_FormsMap.put(form.getName(), form);
            }
            uin.skipAtEnd();
        }
    }

    protected BytesOutputStream getTempBuffer() {
        if (this.m_TempBuffer == null) {
            this.m_TempBuffer = new BytesOutputStream(512);
        }
        return this.m_TempBuffer;
    }

    protected void readBoundary() throws IOException {
        BytesOutputStream buf = this.getTempBuffer();
        while (true) {
            int ret;
            if (-1 == (ret = this.m_Input.read())) {
                throw new IOException("Invalid format MIME part,please check this form 'enctype=\"multipart/form-data\"'!");
            }
            if (13 == ret) continue;
            if (10 == ret) break;
            buf.write(ret);
        }
        this.m_Boundary = buf.detach();
        if (this.m_Boundary == null || this.m_Boundary.length < 2) {
            throw new IOException("Invalid format MIME part(boundary too short)!");
        }
    }

    protected List<WebForm.Header> analyzeHeaders() throws IOException {
        ArrayList<WebForm.Header> headers = new ArrayList<WebForm.Header>();
        WebForm.Header header = null;
        BytesOutputStream buf = this.getTempBuffer();
        Bytes line = null;
        while (true) {
            int ret;
            if ((ret = this.m_Input.read()) < 0) {
                if (headers.size() > 0) {
                    throw new IOException("Invalid format MIME part(headers)!");
                }
                return headers;
            }
            if (13 == ret) continue;
            if (10 == ret) {
                String str;
                if (buf.size() == 0 || (line = buf.getBytes()) == null || line.getSize() == 0) break;
                if (StringUtil.isUtf8((byte[])line.getBytes(), (int)0, (int)line.getSize())) {
                    str = new String(line.getBytes(), 0, line.getSize(), "utf-8");
                    header = new WebForm.Header("charset", "utf-8");
                    headers.add(header);
                } else {
                    str = new String(line.getBytes(), 0, line.getSize(), "gbk");
                }
                int idx = str.indexOf(58);
                if (-1 != idx) {
                    int beginValue = idx + 1;
                    if (' ' == str.charAt(beginValue)) {
                        ++beginValue;
                    }
                    header = new WebForm.Header(str.substring(0, idx), str.substring(beginValue));
                    headers.add(header);
                }
                buf.reset();
                continue;
            }
            buf.write(ret);
        }
        return headers;
    }

    protected class PartInputStream
    extends InputStream {
        byte[] m_Buffer;
        int m_BufferSize;
        int m_ReadOffset;
        int m_Size;
        int m_BoundarySize;
        int m_PartEndBoundary;
        int m_BoundaryOffset;

        PartInputStream() {
            this.m_BoundarySize = WebUpload.this.m_Boundary.length + 2;
            this.m_Buffer = new byte[this.m_BoundarySize * 2 + 2];
            this.m_Size = 0;
            this.m_ReadOffset = 0;
            this.m_BufferSize = 0;
        }

        private boolean checkBoundary() throws IOException {
            if (this.m_BufferSize - this.m_BoundaryOffset >= WebUpload.this.m_Boundary.length && Bytes.compare((byte[])this.m_Buffer, (int)this.m_BoundaryOffset, (byte[])WebUpload.this.m_Boundary, (int)0, (int)WebUpload.this.m_Boundary.length) == 0) {
                int ret;
                int count = this.m_BufferSize - this.m_BoundaryOffset - WebUpload.this.m_Boundary.length;
                if (count > 0) {
                    throw new IOException("\u6570\u636e\u8bfb\u591a\u4e86\uff1f");
                }
                count = 0;
                while (10 != (ret = WebUpload.this.m_Input.read())) {
                    if (ret < 0) {
                        throw new IOException("\u610f\u5916\u7ed3\u675f\uff08\u8fb9\u754c\u540e\u6ca1\u6709\u6362\u884c\u7b26\uff09");
                    }
                    if (45 != ret && 13 != ret) {
                        throw new IOException("\u8fb9\u754c\u5f02\u5e38[" + count + "](" + ret + ')');
                    }
                    ++count;
                }
                this.m_BufferSize = -1;
                return true;
            }
            return false;
        }

        protected boolean fullBuffer() throws IOException {
            int remain;
            if (this.m_ReadOffset < this.m_PartEndBoundary) {
                return true;
            }
            if (this.m_BufferSize < 0) {
                return false;
            }
            int count = this.m_BufferSize - this.m_PartEndBoundary;
            if (count < 1) {
                this.m_ReadOffset = 0;
                this.m_PartEndBoundary = 0;
                this.m_BufferSize = 0;
                this.m_BoundaryOffset = 0;
                remain = 0;
            } else {
                remain = this.m_Buffer.length - this.m_PartEndBoundary;
                if (remain < this.m_BoundarySize) {
                    System.arraycopy(this.m_Buffer, this.m_PartEndBoundary, this.m_Buffer, 0, count);
                    this.m_BoundaryOffset = this.m_BoundaryOffset > this.m_ReadOffset ? this.m_BoundaryOffset - this.m_ReadOffset : 0;
                    this.m_PartEndBoundary = 0;
                    this.m_ReadOffset = 0;
                    this.m_BufferSize = count;
                }
            }
            count = this.m_BoundarySize - count;
            do {
                int ret;
                if ((ret = WebUpload.this.m_Input.read(this.m_Buffer, this.m_BufferSize, count)) < 0) {
                    throw new IOException("\u5185\u5bb9\u672a\u5b8c\u6574\uff0c\u610f\u5916\u7ed3\u675f\uff01");
                }
                this.m_BufferSize += ret;
            } while ((count = this.m_BoundarySize - (this.m_BufferSize - this.m_PartEndBoundary)) > 0);
            if (this.m_PartEndBoundary > 0) {
                if (this.m_BoundaryOffset > 0 && this.m_BoundaryOffset + 1 < this.m_BufferSize && 10 == this.m_Buffer[this.m_BoundaryOffset] && 13 == this.m_Buffer[this.m_BoundaryOffset - 1]) {
                    ++this.m_BoundaryOffset;
                }
                if (this.checkBoundary()) {
                    return false;
                }
                ++this.m_PartEndBoundary;
            }
            while (this.m_PartEndBoundary < this.m_BufferSize) {
                if (13 == this.m_Buffer[this.m_PartEndBoundary]) {
                    this.m_BoundaryOffset = this.m_PartEndBoundary + 1;
                    if (this.m_BoundaryOffset == this.m_BufferSize) break;
                    if (10 == this.m_Buffer[this.m_BoundaryOffset]) {
                        ++this.m_BoundaryOffset;
                        if (this.checkBoundary() || this.m_PartEndBoundary > this.m_ReadOffset) break;
                        ++this.m_PartEndBoundary;
                    }
                }
                ++this.m_PartEndBoundary;
            }
            return this.m_ReadOffset < this.m_PartEndBoundary;
        }

        @Override
        public int read() throws IOException {
            if (this.fullBuffer()) {
                int ret;
                return (ret = this.m_Buffer[this.m_ReadOffset++]) < 0 ? 256 + ret : ret;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int total = 0;
            while (len > 0 && this.fullBuffer()) {
                int count = this.m_PartEndBoundary - this.m_ReadOffset;
                if (count > len) {
                    count = len;
                }
                System.arraycopy(this.m_Buffer, this.m_ReadOffset, b, off, count);
                this.m_ReadOffset += count;
                total += count;
                len -= count;
                off += count;
            }
            return total == 0 && len > 0 ? -1 : total;
        }

        final void skipAtEnd() throws IOException {
            while (this.fullBuffer()) {
                this.m_ReadOffset = this.m_PartEndBoundary;
            }
        }

        public long transfer(OutputStream out) throws IOException {
            long count = 0L;
            while (this.fullBuffer()) {
                int ret = this.m_PartEndBoundary - this.m_ReadOffset;
                out.write(this.m_Buffer, this.m_ReadOffset, ret);
                this.m_ReadOffset += ret;
                count += (long)ret;
            }
            return count;
        }
    }
}

