/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.util;

import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ApiException;

public class ValidateUtil {
    private ValidateUtil() {
    }

    public static void isNull(Object v, String tip) throws ApiException {
        ValidateUtil.checkIllegalArgument(v == null, tip);
    }

    public static void isEmpty(Object v, String tip) throws ApiException {
        if (v instanceof String) {
            ValidateUtil.checkIllegalArgument(StringUtil.isEmpty((String)((String)v)), tip);
        } else {
            ValidateUtil.checkIllegalArgument(v == null, tip);
        }
    }

    public static void isZero(int number, String tip) throws ApiException {
        ValidateUtil.checkIllegalArgument(number == 0, tip);
    }

    public static void gtZero(int number, String tip) throws ApiException {
        ValidateUtil.checkIllegalArgument(number > 0, tip);
    }

    public static void gtOrEqZero(int number, String tip) throws ApiException {
        ValidateUtil.checkIllegalArgument(number >= 0, tip);
    }

    public static void ltZero(int number, String tip) throws ApiException {
        ValidateUtil.checkIllegalArgument(number < 0, tip);
    }

    public static void ltOrEqZero(int number, String tip) throws ApiException {
        ValidateUtil.checkIllegalArgument(number <= 0, tip);
    }

    public static void checkIllegalArgument(boolean condition, String message) throws ApiException {
        ValidateUtil.check(condition, 30001, message);
    }

    public static void check(boolean condition, int code, String message) throws ApiException {
        if (condition) {
            throw new ApiException(code, message);
        }
    }
}

