/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.util;

import cn.weforward.common.util.StringUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class HostUtil {
    public static String findIp() {
        InetAddress host;
        try {
            host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("\u83b7\u53d6ip\u4fe1\u606f\u51fa\u9519:" + e.getMessage(), e);
        }
        return host.getHostAddress();
    }

    public static String getServiceIp(String prefix) {
        InetAddress best;
        block9: {
            best = null;
            try {
                Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                while (ifs.hasMoreElements()) {
                    NetworkInterface ni = ifs.nextElement();
                    Enumeration<InetAddress> ias = ni.getInetAddresses();
                    while (ias.hasMoreElements()) {
                        InetAddress ip = ias.nextElement();
                        if (ip.isLoopbackAddress() || ip.isLinkLocalAddress() || StringUtil.toString((Object)ip.getHostAddress()).indexOf(":") != -1) continue;
                        if (prefix != null && ip.getHostAddress().startsWith(prefix)) {
                            best = ip;
                        } else {
                            byte[] bestAddrs;
                            byte[] adds = ip.getAddress();
                            if (adds == null || adds.length < 4) continue;
                            byte[] byArray = bestAddrs = best == null ? null : best.getAddress();
                            if (-64 == adds[0] && -88 == adds[1]) {
                                if (bestAddrs != null) continue;
                                best = ip;
                                continue;
                            }
                            if (-84 == adds[0] && adds[1] >= 16 && adds[1] <= 31) {
                                if (bestAddrs != null && (-64 != bestAddrs[0] || -88 != bestAddrs[1])) continue;
                                best = ip;
                                continue;
                            }
                            if (10 == adds[0]) {
                                if (bestAddrs != null && (-64 != bestAddrs[0] || -88 != bestAddrs[1]) && (-84 != adds[0] || adds[1] < 16 || adds[1] > 31)) continue;
                                best = ip;
                                continue;
                            }
                            best = ip;
                        }
                        break block9;
                    }
                }
            }
            catch (SocketException e) {
                throw new IllegalStateException("\u83b7\u53d6IP\u5f02\u5e38", e);
            }
        }
        return best == null ? null : best.getHostAddress();
    }
}

