/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.framework.ext;

import cn.weforward.common.util.AntPathPattern;
import cn.weforward.common.util.StringUtil;
import cn.weforward.framework.ApiException;
import cn.weforward.framework.Authorizer;
import cn.weforward.framework.WeforwardSession;
import cn.weforward.framework.util.RequestUtil;
import cn.weforward.protocol.Request;
import cn.weforward.protocol.ops.Right;
import cn.weforward.protocol.ops.User;
import cn.weforward.protocol.ops.UserService;
import cn.weforward.protocol.support.NamingConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthorizer
implements Authorizer {
    private static final Logger _Logger = LoggerFactory.getLogger(UserAuthorizer.class);
    protected UserService m_UserService;
    protected List<String> m_IgnoreUris;
    protected List<String> m_IgnoreCheckRightUris;
    protected int m_Options;
    protected int m_DefaultRightRule = 128;

    public void setDefaultRightRule(String rule) {
        this.m_DefaultRightRule = "allow".equalsIgnoreCase(rule) ? 1 : ("disallow".equalsIgnoreCase(rule) ? 128 : 0);
    }

    public void setUserService(UserService service) {
        this.m_UserService = service;
    }

    public void setIgnoreUris(List<String> uris) {
        if (uris == null) {
            this.m_IgnoreUris = Collections.emptyList();
        } else {
            this.m_IgnoreUris = new ArrayList<String>(uris);
            Collections.sort(this.m_IgnoreUris, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
    }

    public void setIgnoreCheckRightUris(List<String> uris) {
        if (uris == null) {
            this.m_IgnoreCheckRightUris = Collections.emptyList();
        } else {
            this.m_IgnoreCheckRightUris = new ArrayList<String>(uris);
            Collections.sort(this.m_IgnoreCheckRightUris, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
    }

    @Override
    public void auth(Request request) throws ApiException {
        String uri = RequestUtil.getMethod(request);
        if (StringUtil.isEmpty((String)uri)) {
            throw new ApiException(10001, "\u65b9\u6cd5\u540d\u4e3a\u7a7a");
        }
        User user = this.m_UserService.getUserByAccess(request.getAccess().getAccessId());
        WeforwardSession session = WeforwardSession.TLS.getSession();
        if (session != null && user != null) {
            session.bindOperator(user);
        }
        if (UserAuthorizer.match(this.m_IgnoreUris, uri) != null) {
            return;
        }
        if (user == null) {
            throw ApiException.NO_LOGIN;
        }
        if (UserAuthorizer.match(this.m_IgnoreCheckRightUris, uri) != null) {
            return;
        }
        if (!this.checkRight(user, uri)) {
            _Logger.error("\u9a8c\u8bc1\u5931\u8d25:" + uri + "," + user.getName() + "," + user.getRights());
            throw ApiException.AUTH_FAILED;
        }
    }

    private static String match(List<String> patterns, String uri) {
        if (patterns == null) {
            return null;
        }
        for (String pattern : patterns) {
            if (StringUtil.isEmpty((String)pattern) || !UserAuthorizer.match(pattern, uri)) continue;
            return pattern;
        }
        return null;
    }

    private static boolean match(Right right, String uri) {
        String pattern = NamingConverter.camelToWf((String)right.getUriPattern());
        return UserAuthorizer.match(pattern, uri);
    }

    private static boolean match(String pattern, String uri) {
        return AntPathPattern.match((String)pattern, (String)uri);
    }

    protected boolean checkRight(User user, String uri) {
        List<Right> rights = this.getRight(user);
        Right match = null;
        for (Right r : rights) {
            if (!UserAuthorizer.match(r, uri)) continue;
            match = r;
            if (r.getRule() == 128) break;
        }
        if (match == null) {
            return false;
        }
        if (1 == match.getRule()) {
            return true;
        }
        if (128 == match.getRule()) {
            return false;
        }
        return this.m_DefaultRightRule == 1;
    }

    private List<Right> getRight(User user) {
        return user.getRights();
    }
}

