/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.common;

import cn.com.antcloud.api.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwSigns {
    private static final Logger logger = LoggerFactory.getLogger(GwSigns.class);
    private static final Pattern ENCODED_CHARACTERS_PATTERN;
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static List<String> signKeyFilter(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> item : params.entrySet()) {
            if (item.getValue() != null && item.getValue().startsWith("antcloud-base64://")) continue;
            keys.add(item.getKey());
        }
        return keys;
    }

    public static String sign(Map<String, String> params, String algorithm, String secret, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(secret.getBytes(charset), algorithm));
        List<String> keys = GwSigns.signKeyFilter(params);
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            if (i != 0) {
                mac.update("&".getBytes(charset));
            }
            mac.update(GwSigns.urlEncode(key).getBytes(charset));
            mac.update("=".getBytes(charset));
            mac.update(GwSigns.urlEncode(params.get(key)).getBytes(charset));
        }
        byte[] signData = mac.doFinal();
        return Base64.encodeToString(signData, false);
    }

    public static String sign(String text, String algorithm, String secret, Charset charset) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(secret.getBytes(charset), algorithm));
        byte[] signData = mac.doFinal(text.getBytes(charset));
        return Base64.encodeToString(signData, false);
    }

    public static String extractStringToSign(String responseString) {
        String responseNodeKey = "\"response\"";
        String signNodeKey = "\"sign\"";
        int indexOfResponseNode = responseString.indexOf(responseNodeKey);
        int indexOfSignNode = responseString.lastIndexOf(signNodeKey);
        if (indexOfResponseNode < 0) {
            return null;
        }
        if (indexOfSignNode < 0 || indexOfSignNode < indexOfResponseNode) {
            indexOfSignNode = responseString.lastIndexOf(125) - 1;
        }
        int startIndex = responseString.indexOf(123, indexOfResponseNode + responseNodeKey.length());
        int endIndex = responseString.lastIndexOf("}", indexOfSignNode);
        try {
            return responseString.substring(startIndex, endIndex + 1);
        }
        catch (IndexOutOfBoundsException e) {
            logger.error(responseString);
            logger.error("{}, {}", (Object)startIndex, (Object)endIndex);
            throw e;
        }
    }

    public static String attachSign(String responseString, String sign) {
        String signNodeKey = "\"sign\"";
        int indexOfSignNode = responseString.lastIndexOf(signNodeKey);
        if (indexOfSignNode < 0) {
            return null;
        }
        int indexOfOpenQuote = responseString.indexOf(34, indexOfSignNode + signNodeKey.length());
        int indexOfCloseQuote = responseString.indexOf(34, indexOfOpenQuote + 1);
        return responseString.substring(0, indexOfOpenQuote + 1) + sign + responseString.substring(indexOfCloseQuote);
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

