/*
 * Decompiled with CFR 0.152.
 */
package cn.com.antcloud.api.antcloud.rest;

import cn.com.antcloud.api.acapi.AntCloudHttpClient;
import cn.com.antcloud.api.acapi.AntCloudWebUtils;
import cn.com.antcloud.api.acapi.StringUtils;
import cn.com.antcloud.api.antcloud.rest.AntCloudRestClientRequest;
import cn.com.antcloud.api.antcloud.rest.AntCloudRestClientResponse;
import cn.com.antcloud.api.common.BaseGwClient;
import cn.com.antcloud.api.common.ClientException;
import cn.com.antcloud.api.common.GwRestSignUtils;
import cn.com.antcloud.api.common.GwSignType;
import cn.com.antcloud.api.common.GwSigns;
import cn.com.antcloud.api.common.SDKConstants;
import cn.com.antcloud.api.common.SDKUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntCloudRestClient
extends BaseGwClient<AntCloudRestClientRequest, AntCloudRestClientResponse> {
    private static final Logger logger = LoggerFactory.getLogger(AntCloudRestClient.class);
    private static final String URL_DELIMITER = "/";
    private static final String JAVA_SDK_VERSION = "Java-SDK-20180705";

    private AntCloudRestClient(String endpoint, String accessKey, String accessSecret, boolean checkSign, boolean enableAutoRetry, int autoRetryLimit, AntCloudHttpClient client) {
        super(endpoint, accessKey, accessSecret, checkSign, enableAutoRetry, autoRetryLimit, client);
        if (endpoint != null && !endpoint.contains("/api")) {
            throw new IllegalArgumentException("Endpoint should contains /api");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public AntCloudRestClientResponse execute(AntCloudRestClientRequest request) {
        SDKUtils.checkNotNull(request.getUrlPath(), "Url path cannot be null");
        SDKUtils.checkNotNull(request.getHttpMethod(), "Http method cannot be null");
        SDKUtils.checkNotNull(request.getApiVersion(), "Api version cannot be null");
        if (request.getRegionName() == null && request.getProductInstanceId() == null) {
            throw new IllegalArgumentException("Please set region or product instance id");
        }
        request.putHeader("X-AntCloud-Access-Key", this.getAccessKey());
        request.putHeader("X-AntCloud-Req-Msg-Id", SDKUtils.generateReqMsgId());
        request.putHeader("X-AntCloud-Req-Time", SDKUtils.formatDate(new Date()));
        request.putHeader("X-AntCloud-SDK-Version", JAVA_SDK_VERSION);
        String signType = request.getHeaderValue("X-AntCloud-Sign-Type");
        if (StringUtils.isEmpty(signType)) {
            signType = GwSignType.HmacSHA1.getCode();
            request.putHeader("X-AntCloud-Sign-Type", signType);
        }
        try {
            String stringToSign = GwRestSignUtils.getStringToSign(request.getUrlPath(), request.getHttpMethod().getCode(), request.getSignHeaders(), request.getQueryParams(), request.getPostBody());
            if (logger.isDebugEnabled()) {
                logger.debug("String to sign: \n{}", (Object)stringToSign);
            }
            String sign = GwSigns.sign(stringToSign, signType, this.getAccessSecret(), SDKConstants.SIGN_CHARSET);
            request.putHeader("X-AntCloud-Sign", sign);
        }
        catch (Exception e) {
            throw new ClientException("UNKNOWN_ERROR", e);
        }
        try {
            String apiUrl = this.getCorrectUrl(this.getEndpoint(), request.getUrlPath());
            String responseString = AntCloudWebUtils.doRestRequest(apiUrl, request.getHttpMethod(), request.getHeaders(), request.getQueryParams(), request.getPostBody(), this.httpClient.getHttpConfig().getConnectionTimeoutMillis(), this.httpClient.getHttpConfig().getReadTimeoutMillis(), null);
            JSONObject wholeJson = JSON.parseObject((String)responseString);
            if (wholeJson == null) {
                logger.error(responseString);
                throw new ClientException("TRANSPORT_ERROR", "Unexpected gateway response: " + responseString);
            }
            JSONObject responseNode = wholeJson.getJSONObject("response");
            if (responseNode == null) {
                logger.error(responseString);
                throw new ClientException("TRANSPORT_ERROR", "Unexpected gateway response: " + responseString);
            }
            AntCloudRestClientResponse response = (AntCloudRestClientResponse)this.newResponse();
            response.setData(responseNode);
            if (response.isSuccess() && this.isCheckSign()) {
                String calculatedSign;
                String sign = wholeJson.getString("sign");
                String stringToSign = GwSigns.extractStringToSign(responseString);
                try {
                    calculatedSign = GwSigns.sign(stringToSign, signType, this.getAccessSecret(), SDKConstants.SIGN_CHARSET);
                }
                catch (Exception e) {
                    throw new ClientException("INVALID_RESPONSE_SIGNATURE", "Invalid signature in response");
                }
                if (!calculatedSign.equals(sign)) {
                    throw new ClientException("INVALID_RESPONSE_SIGNATURE", "Invalid signature in response");
                }
            }
            return response;
        }
        catch (IOException e) {
            throw new ClientException("TRANSPORT_ERROR", e);
        }
    }

    private String getCorrectUrl(String ... urlFragments) {
        for (int i = 0; i < urlFragments.length; ++i) {
            String urlFragment = urlFragments[i];
            if (urlFragment == null) {
                throw new IllegalArgumentException("Url fragment can't be null");
            }
            if (i != 0 && !urlFragment.startsWith(URL_DELIMITER)) {
                urlFragment = URL_DELIMITER + urlFragment;
            }
            if (urlFragment.endsWith(URL_DELIMITER)) {
                urlFragment = urlFragment.substring(0, urlFragment.length() - 1);
            }
            urlFragments[i] = urlFragment;
        }
        StringBuilder sb = new StringBuilder();
        for (String urlFragment : urlFragments) {
            sb.append(urlFragment);
        }
        return sb.toString();
    }

    public static class Builder
    extends BaseGwClient.Builder<AntCloudRestClient, Builder> {
    }
}

