/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.netcode;

import ch.awae.netcode.NetcodeServer;
import ch.awae.netcode.NetcodeServerImpl;
import ch.awae.netcode.RandomStringGenerator;
import ch.awae.netcode.SecurityMode;
import ch.awae.netcode.SocketMode;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public final class NetcodeServerFactory {
    private final SocketMode socketMode;
    private final SecurityMode securityMode;
    private int maxClients = 50;
    private Predicate<String> appIdValidator = s -> true;
    private Supplier<String> channelIdProvider = new RandomStringGenerator(6);
    private List<Consumer<ServerSocket>> afterBind = new ArrayList<Consumer<ServerSocket>>();
    private final int port;

    public NetcodeServerFactory(int port, SocketMode socketMode, SecurityMode securityMode) {
        Objects.requireNonNull(socketMode, "socketMode may not be null");
        Objects.requireNonNull(securityMode, "securityMode may not be null");
        this.socketMode = socketMode;
        if (socketMode == SocketMode.PLAIN && securityMode != SecurityMode.ANY) {
            throw new IllegalArgumentException("incompatible securityMode");
        }
        this.securityMode = securityMode;
        this.port = port;
    }

    public NetcodeServerFactory(int port) {
        this(port, SocketMode.TLS, SecurityMode.ANONYMOUS);
    }

    public void runAfterBind(Consumer<ServerSocket> runner) {
        this.afterBind.add(runner);
    }

    public void setMaxClients(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("backlog must be positive");
        }
        this.maxClients = max;
    }

    public NetcodeServer start() throws IOException {
        ServerSocketFactory ssf = this.socketMode == SocketMode.PLAIN ? ServerSocketFactory.getDefault() : SSLServerSocketFactory.getDefault();
        ServerSocket ss = ssf.createServerSocket(this.port, this.maxClients);
        if (this.socketMode != SocketMode.PLAIN) {
            this.applySecuritySettings((SSLServerSocket)ss);
        }
        for (Consumer<ServerSocket> f : this.afterBind) {
            f.accept(ss);
        }
        NetcodeServerImpl ns = new NetcodeServerImpl(ss, this.appIdValidator, this.channelIdProvider);
        ns.start();
        return ns;
    }

    private void applySecuritySettings(SSLServerSocket ss) {
        ArrayList<String> ciphers = new ArrayList<String>();
        for (String c : ss.getSupportedCipherSuites()) {
            if (this.socketMode == SocketMode.SSL && !c.startsWith("SSL") || this.socketMode == SocketMode.TLS && !c.startsWith("TLS") || this.securityMode == SecurityMode.CERTIFICATE && c.contains("_anon_") || this.securityMode == SecurityMode.ANONYMOUS && !c.contains("_anon_")) continue;
            ciphers.add(c);
        }
        ss.setEnabledCipherSuites(ciphers.toArray(new String[0]));
    }

    public SocketMode getSocketMode() {
        return this.socketMode;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public Predicate<String> getAppIdValidator() {
        return this.appIdValidator;
    }

    public Supplier<String> getChannelIdProvider() {
        return this.channelIdProvider;
    }

    public int getPort() {
        return this.port;
    }

    public void setAppIdValidator(Predicate<String> appIdValidator) {
        this.appIdValidator = appIdValidator;
    }

    public void setChannelIdProvider(Supplier<String> channelIdProvider) {
        this.channelIdProvider = channelIdProvider;
    }
}

