/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.api.deployable;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cactus.integration.api.deployable.WarDeployableFile;
import org.apache.cactus.integration.api.exceptions.CactusRuntimeException;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class WarParser {
    public static final WarDeployableFile parse(File theDeployableFile) {
        WarDeployableFile deployable = new WarDeployableFile();
        try {
            deployable.setFile(theDeployableFile);
            deployable.setWarArchive((WarArchive)new DefaultWarArchive((InputStream)new FileInputStream(theDeployableFile)));
            deployable.setTestContext(WarParser.parseWebContext(theDeployableFile));
            deployable.setServletRedirectorMapping(WarParser.parseServletRedirectorMapping(deployable.getWarArchive()));
            deployable.setFilterRedirectorMapping(WarParser.parseFilterRedirectorMapping(deployable.getWarArchive()));
            deployable.setJspRedirectorMapping(WarParser.parseJspRedirectorMapping(deployable.getWarArchive()));
        }
        catch (IOException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", e);
        }
        catch (ParserConfigurationException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", e);
        }
        catch (SAXException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", e);
        }
        catch (JDOMException e) {
            throw new CactusRuntimeException("Failed to parse deployment descriptor for WAR file [" + theDeployableFile + "].", (Exception)((Object)e));
        }
        return deployable;
    }

    protected static String parseWebContext(File theDeployableFile) {
        String context = theDeployableFile.getName();
        int warIndex = context.toLowerCase().lastIndexOf(".war");
        if (warIndex >= 0) {
            context = context.substring(0, warIndex);
        }
        return context;
    }

    static String parseServletRedirectorMapping(WarArchive theWar) throws SAXException, IOException, ParserConfigurationException, JDOMException {
        Iterator servletNames = WebXmlUtils.getServletNamesForClass((WebXml)theWar.getWebXml(), (String)"org.apache.cactus.server.ServletTestRedirector");
        if (servletNames.hasNext()) {
            while (servletNames.hasNext()) {
                String name = (String)servletNames.next();
                Iterator mappings = WebXmlUtils.getServletMappings((WebXml)theWar.getWebXml(), (String)name);
                if (!mappings.hasNext()) continue;
                return (String)mappings.next();
            }
        }
        return null;
    }

    static String parseFilterRedirectorMapping(WarArchive theWar) throws IOException, SAXException, ParserConfigurationException, JDOMException {
        Iterator filterNames = WebXmlUtils.getFilterNamesForClass((WebXml)theWar.getWebXml(), (String)"org.apache.cactus.server.FilterTestRedirector");
        if (filterNames.hasNext()) {
            String name = (String)filterNames.next();
            Iterator mappings = WebXmlUtils.getFilterMappings((WebXml)theWar.getWebXml(), (String)name);
            if (mappings.hasNext()) {
                return (String)mappings.next();
            }
        }
        return null;
    }

    static String parseJspRedirectorMapping(WarArchive theWar) throws IOException, SAXException, ParserConfigurationException, JDOMException {
        String jspRedirectorPath = theWar.findResource("jspRedirector.jsp");
        if (jspRedirectorPath != null) {
            jspRedirectorPath = "/" + jspRedirectorPath;
            Iterator jspNames = WebXmlUtils.getServletNamesForClass((WebXml)theWar.getWebXml(), (String)jspRedirectorPath);
            if (jspNames.hasNext()) {
                String name = (String)jspNames.next();
                Iterator mappings = WebXmlUtils.getServletMappings((WebXml)theWar.getWebXml(), (String)name);
                if (mappings.hasNext()) {
                    return (String)mappings.next();
                }
            }
        }
        return null;
    }
}

