/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    private final Object[] items;
    private int takeIndex;
    private int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    private void insert(Object x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private Object extract() {
        Object[] items = this.items;
        Object x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return x;
    }

    void removeAt(int i) {
        Object[] items = this.items;
        if (i == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int nexti;
            while ((nexti = this.inc(i)) != this.putIndex) {
                items[i] = items[nexti];
                i = nexti;
            }
            items[i] = null;
            this.putIndex = i;
        }
        --this.count;
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int capacity) {
        this(capacity, false);
    }

    public ArrayBlockingQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public ArrayBlockingQueue(int capacity, boolean fair, Collection c) {
        this(capacity, fair);
        if (capacity < c.size()) {
            throw new IllegalArgumentException();
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public boolean add(Object e) {
        return super.add(e);
    }

    public boolean offer(Object e) {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl2 = false;
                Object var6_4 = null;
                lock.unlock();
                return bl2;
            }
            this.insert(e);
            bl = true;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
        Object var6_5 = null;
        lock.unlock();
        return bl;
    }

    public void put(Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.count == items.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insert(e);
            Object var6_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        block8: {
            if (e == null) {
                throw new NullPointerException();
            }
            nanos = unit.toNanos(timeout);
            lock = this.lock;
            lock.lockInterruptibly();
            try {
                deadline = Utils.nanoTime() + nanos;
                while (true) lbl-1000:
                // 2 sources

                {
                    if (this.count != this.items.length) {
                        this.insert(e);
                        var10_7 = true;
                        var13_9 = null;
                        lock.unlock();
                        return var10_7;
                    }
                    if (nanos <= 0L) {
                        var10_8 = false;
                        break block8;
                    }
                    try {
                        this.notFull.await(nanos, TimeUnit.NANOSECONDS);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        this.notFull.signal();
                        throw ie;
                    }
                    break;
                }
            }
            catch (Throwable var12_13) {
                var13_11 = null;
                lock.unlock();
                throw var12_13;
            }
            {
                ** while (true)
            }
        }
        var13_10 = null;
        lock.unlock();
        return var10_8;
    }

    public Object poll() {
        Object object;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object x;
            if (this.count == 0) {
                Object var2_2 = null;
                Object var6_3 = null;
                lock.unlock();
                return var2_2;
            }
            object = x = this.extract();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            lock.unlock();
            throw throwable;
        }
        Object var6_4 = null;
        lock.unlock();
        return object;
    }

    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            Object x;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            Object object = x = this.extract();
            Object var5_5 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        block7: {
            nanos = unit.toNanos(timeout);
            lock = this.lock;
            lock.lockInterruptibly();
            try {
                deadline = Utils.nanoTime() + nanos;
                while (true) lbl-1000:
                // 2 sources

                {
                    if (this.count != 0) {
                        var10_8 = x = this.extract();
                        var12_10 = null;
                        lock.unlock();
                        return var10_8;
                    }
                    if (nanos <= 0L) {
                        var9_7 = null;
                        break block7;
                    }
                    try {
                        this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        this.notEmpty.signal();
                        throw ie;
                    }
                    break;
                }
            }
            catch (Throwable var11_13) {
                var12_12 = null;
                lock.unlock();
                throw var11_13;
            }
            {
                ** while (true)
            }
        }
        var12_11 = null;
        lock.unlock();
        return var9_7;
    }

    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.count == 0 ? null : this.items[this.takeIndex];
            Object var4_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.items.length - this.count;
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (true) {
                if (k++ >= this.count) {
                    boolean bl2 = false;
                    Object var9_7 = null;
                    lock.unlock();
                    return bl2;
                }
                if (o.equals(items[i])) {
                    this.removeAt(i);
                    bl = true;
                    break;
                }
                i = this.inc(i);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        lock.unlock();
        return bl;
    }

    public boolean contains(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (k++ < this.count) {
                if (o.equals(items[i])) {
                    boolean bl2 = true;
                    Object var8_8 = null;
                    lock.unlock();
                    return bl2;
                }
                i = this.inc(i);
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            lock.unlock();
            throw throwable;
        }
        Object var8_9 = null;
        lock.unlock();
        return bl;
    }

    public Object[] toArray() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            Object[] objectArray = a;
            Object var8_7 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object[] toArray(Object[] a) {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (a.length < this.count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
            }
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            if (a.length > this.count) {
                a[this.count] = null;
            }
            Object[] objectArray = a;
            Object var8_7 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = super.toString();
            Object var4_3 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void clear() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = this.count;
            while (k-- > 0) {
                items[i] = null;
                i = this.inc(i);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
            this.notFull.signalAll();
            Object var6_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int n = 0;
            int max = this.count;
            while (n < max) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
                ++n;
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n2 = n;
            Object var9_8 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int n = 0;
            int sz = this.count;
            int max = maxElements < this.count ? maxElements : this.count;
            while (n < max) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
                ++n;
            }
            if (n > 0) {
                this.count -= n;
                this.takeIndex = i;
                this.notFull.signalAll();
            }
            int n2 = n;
            Object var11_10 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Iterator iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr();
            Object var4_3 = null;
            lock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    private class Itr
    implements Iterator {
        private int nextIndex;
        private Object nextItem;
        private int lastRet = -1;

        Itr() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                this.nextItem = ArrayBlockingQueue.this.items[ArrayBlockingQueue.this.takeIndex];
            }
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == ArrayBlockingQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ArrayBlockingQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        public Object next() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object x = this.nextItem;
                this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex);
                this.checkNext();
                Object object = x;
                Object var5_4 = null;
                lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                lock.unlock();
                throw throwable;
            }
        }

        public void remove() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                int i = this.lastRet;
                if (i == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int ti = ArrayBlockingQueue.this.takeIndex;
                ArrayBlockingQueue.this.removeAt(i);
                this.nextIndex = i == ti ? ArrayBlockingQueue.this.takeIndex : i;
                this.checkNext();
                Object var5_4 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }
}

